/* assembly2002demo33.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Elevator business */
#include "assembly2002demo.h"

static void params_33_verticalblur(void *d, long time) {
  int patpostoindex[]={ ELEVATOR1, ELEVATOR1, ELEVATOR2, ELEVATOR2,
			ELEVATOR2, ELEVATOR2, ELEVATOR2, ELEVATOR2,
			/* 008 */
			ELEVATOR3, ELEVATOR3, ELEVATOR4, ELEVATOR4,
			ELEVATOR5, ELEVATOR5, EYE, ELEVATOR5,
			/* 016 */
			ELEVATOR5, ELEVATOR5, ELEVATOR5, ELEVATOR5,
			ELEVATOR6, ELEVATOR6, ELEVATOR7, ELEVATOR7,
			/* 024 */
			ELEVATOR8, ELEVATOR8, ELEVATOR9, ELEVATOR8,
			ELEVATOR7, ELEVATOR6, ELEVATOR4, ELEVATOR2,

			ELEVATOR1, ELEVATOR1, ELEVATOR2, ELEVATOR2,
			ELEVATOR2, ELEVATOR2, ELEVATOR2, ELEVATOR2,
			/* 008 */
			ELEVATOR3, ELEVATOR3, ELEVATOR4, ELEVATOR4,
			ELEVATOR5, ELEVATOR5, EYE, ELEVATOR5,
			/* 016 */
			ELEVATOR5, ELEVATOR5, ELEVATOR5, ELEVATOR5,
			ELEVATOR6, ELEVATOR6, ELEVATOR7, ELEVATOR7,
			/* 024 */
			ELEVATOR8, ELEVATOR8, ELEVATOR9, ELEVATOR8,
			ELEVATOR7, ELEVATOR6, ELEVATOR4, ELEVATOR2,

			ELEVATOR1, ELEVATOR1, ELEVATOR2, ELEVATOR2,
			ELEVATOR2, ELEVATOR2, ELEVATOR2, ELEVATOR2,
			/* 008 */
			ELEVATOR3, ELEVATOR3, ELEVATOR4, ELEVATOR4,
			ELEVATOR5, ELEVATOR5, EYE, ELEVATOR5,
			/* 016 */
			ELEVATOR5, ELEVATOR5, ELEVATOR5, ELEVATOR5,
			ELEVATOR6, ELEVATOR6, ELEVATOR7, ELEVATOR7,
			/* 024 */
			ELEVATOR8, ELEVATOR8, ELEVATOR9, ELEVATOR8,
			ELEVATOR7, ELEVATOR6, ELEVATOR4, ELEVATOR2,

			ELEVATOR1, ELEVATOR1, ELEVATOR2, ELEVATOR2,
			ELEVATOR2, ELEVATOR2, ELEVATOR2, ELEVATOR2,
			/* 008 */
			ELEVATOR3, ELEVATOR3, ELEVATOR4, ELEVATOR4,
			ELEVATOR5, ELEVATOR5, EYE, ELEVATOR5,
			/* 016 */
			ELEVATOR5, ELEVATOR5, ELEVATOR5, ELEVATOR5,
			ELEVATOR6, ELEVATOR6, ELEVATOR7, ELEVATOR7,
			/* 024 */
			ELEVATOR8, ELEVATOR8, ELEVATOR9, ELEVATOR8,
			ELEVATOR7, ELEVATOR6, ELEVATOR4, ELEVATOR2,
  };
  int patpostomodulo[]={ 1,  1,  1,  1,  1,  1,  1,  1, 
			 1,  1,  1,  1,  160,120,160,120,
			 80, 40, 160,120,80, 40, 160,120,
			 80, 40, 1,  1,  1,  1,  1,  1,  
			 1,  1,  1,  1,  1,  1,  1,  1, 
			 1,  1,  1,  1,  1,  1,  1,  1, 
			 1,  1,  1,  1,  160,120,80, 40, 
			 160,120,80, 40, 160,120,80, 40, 
			 1,  1,  1,  1,  1,  1,  1,  1, 
			 1,  1,  1,  1,  160,120,160,120,
			 80, 40, 160,120,80, 40, 160,120,
			 80, 40, 1,  1,  1,  1,  1,  1,  
			 1,  1,  1,  1,  1,  1,  1,  1, 
			 1,  1,  1,  1,  1,  1,  1,  1, 
			 1,  1,  1,  1,  160,120,80, 40, 
			 160,120,80, 40, 160,120,80, 40, 
  };
  verticalblur_data *data=(verticalblur_data *)d;
  int patpos, index;
  time-=PART_33_START;
  if(time<0)
    time=0;

  patpos=(time/SONGPOSTOTIME(1, 1))%128;
  index=patpostoindex[patpos];

  if(index==EYE)
    data->source=pictures[TEMP];
  else
    data->source=pictures[index];

  data->amount=(rand()%patpostomodulo[patpos])+1;
}

static void params_33_horizontalstretch(void *d, long time) {
  horizontalstretch_data *data=(horizontalstretch_data *)d;
  time-=PART_33_START;
  if(time<0)
    time=0;

  /* Golden section horizontally: 247 153 */
  if(time<SONGPOSTOTIME(1, 32)) {
    data->position=0;
    data->length=0;
  } else if(time<SONGPOSTOTIME(2, 0)) {
    data->position=100+53*cos((double)(time-SONGPOSTOTIME(1, 32))*M_PI/3/SONGPOSTOTIME(1, 32));
    data->length=-data->position;
  } else if(time<SONGPOSTOTIME(2, 32)) {
    data->position=0;
    data->length=0;
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->position=300-53*cos((double)(time-SONGPOSTOTIME(2, 32))*M_PI/3/SONGPOSTOTIME(1, 32));
    data->length=data->dest->width-data->position;
  }
}

static int add_position=0;

static void params_33_add(void *d, long time) {
  add_data *data=(add_data *)d;
  long add_positions[]={
    0, 
    SONGPOSTOTIME(1, 44), SONGPOSTOTIME(1, 48),
    SONGPOSTOTIME(1, 54), SONGPOSTOTIME(1, 58), SONGPOSTOTIME(1, 62),
    SONGPOSTOTIME(2, 44), SONGPOSTOTIME(2, 48),
    SONGPOSTOTIME(2, 54), SONGPOSTOTIME(2, 58), SONGPOSTOTIME(2, 62),
    SONGPOSTOTIME(4, 0)
  };

  time-=PART_33_START;
  if(time<0)
    time=0;

  while(add_positions[add_position+1]<=time)
    add_position++;

  if(time-add_positions[add_position]>255)
    data->color=0;
  else {
    if(add_position>0)
      data->color=((127-(time-add_positions[add_position])/2)<<24|0xffffff);
    else
      data->color=((255-(time-add_positions[add_position]))<<24|0xffffff);
  }
}

static void params_33_copy(void *d, long time) {
  int patpostoindex[]={ MIXER1, MIXER2, MIXER1, MIXER2, 
			MIXER1, MIXER2, MIXER3, MIXER4,
			/* 008 */
			MIXER1, MIXER2, MIXER3, MIXER4,
			MIXER1, MIXER2, MIXER3, MIXER4,
			/* 016 */
			MIXER4, MIXER4, MIXER1, MIXER2,
			MIXER1, MIXER2, MIXER1, MIXER2,
			/* 024 */
			MIXER1, MIXER2, MIXER1, MIXER2,
			MIXER3, MIXER4, MIXER4, MIXER4
  };
  copy_data *data=(copy_data *)d;
  int patpos, index;
  time-=PART_33_START;
  if(time<0)
    time=0;

  patpos=(time/SONGPOSTOTIME(1, 1))%32;
  index=patpostoindex[patpos];
  data->source=pictures[index];
}

static void params_33_copy_text1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_33_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 28)) {
    data->alpha=0;
    data->source=pictures[FEAR];
    data->sourcewidth=data->source->width;
    data->sourceheight=data->source->height;
    data->destwidth=data->source->width;
    data->destheight=data->source->height;
    data->desty=190;
  } else if(time<SONGPOSTOTIME(2, 0)) {
    data->destx=220*sin((double)(time-SONGPOSTOTIME(1, 28))*M_PI/2/SONGPOSTOTIME(1, 36));
    data->alpha=63*sin((double)(time-SONGPOSTOTIME(1, 28))*M_PI/SONGPOSTOTIME(1, 36));
  } else if(time<SONGPOSTOTIME(2, 28)) {
    data->alpha=0;
    data->source=pictures[INSECURITY];
    data->sourcewidth=data->source->width;
    data->sourceheight=data->source->height;
    data->destwidth=data->source->width;
    data->destheight=data->source->height;
    data->desty=152;
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->destx=data->dest->width-250*sin((double)(time-SONGPOSTOTIME(2, 28))*M_PI/2/SONGPOSTOTIME(1, 36));
    data->alpha=63*sin((double)(time-SONGPOSTOTIME(2, 28))*M_PI/SONGPOSTOTIME(1, 36));
  }
}

static void params_33_copy_text2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_33_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 29)) {
    data->alpha=0;
    data->source=pictures[FEAR];
    data->sourcewidth=data->source->width;
    data->sourceheight=data->source->height;
    data->destwidth=data->source->width;
    data->destheight=data->source->height;
    data->desty=190;
  } else if(time<SONGPOSTOTIME(2, 1)) {
    data->destx=220*sin((double)(time-SONGPOSTOTIME(1, 29))*M_PI/2/SONGPOSTOTIME(1, 36));
    data->alpha=63*sin((double)(time-SONGPOSTOTIME(1, 29))*M_PI/SONGPOSTOTIME(1, 36));
  } else if(time<SONGPOSTOTIME(2, 29)) {
    data->alpha=0;
    data->source=pictures[INSECURITY];
    data->sourcewidth=data->source->width;
    data->sourceheight=data->source->height;
    data->destwidth=data->source->width;
    data->destheight=data->source->height;
    data->desty=152;
  } else if(time<SONGPOSTOTIME(3, 1)) {
    data->destx=data->dest->width-250*sin((double)(time-SONGPOSTOTIME(2, 29))*M_PI/2/SONGPOSTOTIME(1, 36));
    data->alpha=63*sin((double)(time-SONGPOSTOTIME(2, 29))*M_PI/SONGPOSTOTIME(1, 36));
  }
}

void part_33() {
  copy_data *copydata;
  horizontalstretch_data *hsdata;
  verticalblur_data *vbdata;
  add_data *adddata;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 7. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_33_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 6. Copy mixer */
  effectlist=effectlistentry_new(effect_new(copy_new, params_33_copy),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[MIXER1];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[MIXER1]->width;
  copydata->sourceheight=pictures[MIXER1]->height;
  copydata->destwidth=pictures[MIXER1]->width;
  copydata->destheight=pictures[MIXER1]->height;
  copydata->alpha=63;
  copydata->mode=COPY_MODE_ADD;
  copydata->interpolate=0;

  /* 5. Copy text2 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_33_copy_text2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[FEAR];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=135;
  copydata->sourcewidth=pictures[FEAR]->width;
  copydata->sourceheight=pictures[FEAR]->height;
  copydata->destwidth=pictures[FEAR]->width;
  copydata->destheight=pictures[FEAR]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy text1 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_33_copy_text1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[FEAR];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=135;
  copydata->sourcewidth=pictures[FEAR]->width;
  copydata->sourceheight=pictures[FEAR]->height;
  copydata->destwidth=pictures[FEAR]->width;
  copydata->destheight=pictures[FEAR]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Strech them */
  effectlist=effectlistentry_new(effect_new(horizontalstretch_new,
					    params_33_horizontalstretch),
				 effectlist);
  hsdata=(horizontalstretch_data *)effectlist->effect->data;
  hsdata->dest=&screenbuffer;
  hsdata->position=0;
  hsdata->length=0;

  /* 2. Copy design */
  effectlist=effectlistentry_new(effect_new(copy_new, NULL), effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[DESIGN3];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[DESIGN3]->width;
  copydata->sourceheight=pictures[DESIGN3]->height;
  copydata->destwidth=pictures[DESIGN3]->width;
  copydata->destheight=pictures[DESIGN3]->height;
  copydata->alpha=15;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 1. Blur elevator */
  effectlist=effectlistentry_new(effect_new(verticalblur_new,
					    params_33_verticalblur),
				 effectlist);
  vbdata=(copy_data *)effectlist->effect->data;
  vbdata->source=pictures[ELEVATOR1];
  vbdata->dest=&screenbuffer;
  vbdata->amount=1;

  /* Copy the eye to a temporary buffer */
  copydata=(copy_data *)calloc(sizeof(copy_data), 1);
  copydata->source=pictures[EYE];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[EYE]->width;
  copydata->sourceheight=pictures[EYE]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=128;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
  copy_run(copydata, 0);
  free(copydata);
}
