/* assembly2002demo37.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Lapin Kulta style background with stuff over it */
#include "assembly2002demo.h"

static void params_37_verticalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;
  time-=PART_37_START;
  if(time<0)
    time=0;

  if(time<=SONGPOSTOTIME(4, 32))
    data->amount=1;
  else
    data->amount=rand()%((time-SONGPOSTOTIME(4, 32))/8+1)+1;
}

static void params_37_copy_lapinkulta(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_37_START;
  if(time<0)
    time=0;

  data->alpha=255-255*pow((double)time/(double)SONGPOSTOTIME(5, 0), 2);
  data->sourcex=760*pow((double)time/(double)SONGPOSTOTIME(5, 0), 2);
}

static void params_37_copy_water1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_37_START;
  if(time<0)
    time=0;

  data->source=pictures[WATER1+(time/SONGPOSTOTIME(1, 2))%4];
  data->alpha=(time%SONGPOSTOTIME(1, 2))*time*255/SONGPOSTOTIME(5, 0)/SONGPOSTOTIME(1, 2);
}

static void params_37_copy_water2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_37_START;
  if(time<0)
    time=0;

  data->source=pictures[WATER1+(time/SONGPOSTOTIME(1, 2)+1)%4];
  data->alpha=(SONGPOSTOTIME(1, 2)-1-(time%SONGPOSTOTIME(1, 2)))*time*255/SONGPOSTOTIME(5, 0)/SONGPOSTOTIME(1, 2);
}

static void params_37_copy_beer(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_37_START;
  if(time<0)
    time=0;

  data->alpha=39*pow((double)time/(double)SONGPOSTOTIME(5, 0), 2);
}

static void params_37_copy_text(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_37_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(3, 0)) {
    int s=9*sin((double)time*M_PI/2/SONGPOSTOTIME(3, 0));
    data->source=pictures[PEACEOFMIND];
    data->destx=240+(rand()%(10-s))-s/2;
    data->desty=30+(rand()%(10-s))-s/2;
    data->alpha=63*sin((double)time*M_PI/SONGPOSTOTIME(3, 0));
  } else {
    int s=9*sin((double)(time-SONGPOSTOTIME(3, 0))*M_PI/2/SONGPOSTOTIME(3, 0));
    data->source=pictures[ESCAPINGREALITY];
    data->destx=15+(rand()%(10-s))-s/2;
    data->desty=120+(rand()%(10-s))-s/2;
    data->alpha=63*sin((double)(time-SONGPOSTOTIME(3, 0))*M_PI/SONGPOSTOTIME(3, 0));
  }
  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->source->width;
  data->destheight=data->source->height;
}

static void params_37_copy_small1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_37_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->destx=277;
    data->desty=259;
    data->source=pictures[LAPINKULTASMALL1];
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->destx=87;
    data->desty=259;
    data->source=pictures[LAPINKULTASMALL4];
  } else if(time<SONGPOSTOTIME(4, 0)) {
    data->destx=359;
    data->desty=5;
    data->source=pictures[LAPINKULTASMALL7];
  } else {
    data->destx=5;
    data->desty=5;
    data->source=pictures[LAPINKULTASMALL10];
  }
  
  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);

  if(time<SONGPOSTOTIME(1, 52) || time>=SONGPOSTOTIME(1, 56))
    data->alpha=0;
  else
    data->alpha=255;
}

static void params_37_copy_small2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_37_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->destx=318;
    data->desty=259;
    data->source=pictures[LAPINKULTASMALL2];
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->destx=46;
    data->desty=259;
    data->source=pictures[LAPINKULTASMALL5];
  } else if(time<SONGPOSTOTIME(4, 0)) {
    data->destx=318;
    data->desty=5;
    data->source=pictures[LAPINKULTASMALL8];
  } else {
    data->destx=46;
    data->desty=5;
    data->source=pictures[LAPINKULTASMALL11];
  }

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);

  if(time<SONGPOSTOTIME(1, 56) || time>=SONGPOSTOTIME(1, 60))
    data->alpha=0;
  else
    data->alpha=255;
}

static void params_37_copy_small3(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_37_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->destx=359;
    data->desty=259;
    data->source=pictures[LAPINKULTASMALL3];
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->destx=5;
    data->desty=259;
    data->source=pictures[LAPINKULTASMALL6];
  } else if(time<SONGPOSTOTIME(4, 0)) {
    data->destx=277;
    data->desty=5;
    data->source=pictures[LAPINKULTASMALL9];
  } else {
    data->destx=87;
    data->desty=5;
    data->source=pictures[LAPINKULTASMALL12];
  }

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);

  if(time<SONGPOSTOTIME(1, 60))
    data->alpha=0;
  else
    data->alpha=255;
}

static void params_37_add(void *d, long time) {
  add_data *data=(add_data *)d;

  time-=PART_37_START;
  if(time<0)
    time=0;

  if(time/4>255)
    data->color=0;
  else 
    data->color=((255-(time/4))<<24|0xffffff);
}

void part_37() {
  copy_data *copydata;
  verticalblur_data *vbdata;
  add_data *adddata;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 11. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_37_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 10. Blur it */
  effectlist=effectlistentry_new(effect_new(verticalblur_new, 
					    params_37_verticalblur),
				 effectlist);
  vbdata=(verticalblur_data *)effectlist->effect->data;
  vbdata->source=pictures[TEMP];
  vbdata->dest=&screenbuffer;
  vbdata->amount=1;

  /* 9. Copy small3 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_37_copy_small3),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[LAPINKULTASMALL3];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=359;
  copydata->desty=259;
  copydata->sourcewidth=pictures[LAPINKULTASMALL3]->width;
  copydata->sourceheight=pictures[LAPINKULTASMALL3]->height;
  copydata->destwidth=pictures[LAPINKULTASMALL3]->width;
  copydata->destheight=pictures[LAPINKULTASMALL3]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 8. Copy small2 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_37_copy_small2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[LAPINKULTASMALL2];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=318;
  copydata->desty=259;
  copydata->sourcewidth=pictures[LAPINKULTASMALL2]->width;
  copydata->sourceheight=pictures[LAPINKULTASMALL2]->height;
  copydata->destwidth=pictures[LAPINKULTASMALL2]->width;
  copydata->destheight=pictures[LAPINKULTASMALL2]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 7. Copy small1 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_37_copy_small1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[LAPINKULTASMALL1];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=277;
  copydata->desty=259;
  copydata->sourcewidth=pictures[LAPINKULTASMALL1]->width;
  copydata->sourceheight=pictures[LAPINKULTASMALL1]->height;
  copydata->destwidth=pictures[LAPINKULTASMALL1]->width;
  copydata->destheight=pictures[LAPINKULTASMALL1]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 6. Copy text2 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_37_copy_text),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=15;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 5. Copy text1 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_37_copy_text),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=15;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy beer */
  effectlist=effectlistentry_new(effect_new(copy_new, params_37_copy_beer),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BEER];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=0;
  copydata->sourcewidth=pictures[BEER]->width;
  copydata->sourceheight=pictures[BEER]->height;
  copydata->destwidth=pictures[BEER]->width;
  copydata->destheight=pictures[BEER]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_ADD;
  copydata->interpolate=0;

  /* 3. Copy water */
  effectlist=effectlistentry_new(effect_new(copy_new, params_37_copy_water2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[WATER2];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_ADD;
  copydata->interpolate=0;

  /* 2. Copy water */
  effectlist=effectlistentry_new(effect_new(copy_new, params_37_copy_water1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[WATER1];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_ADD;
  copydata->interpolate=0;

  /* 1. Copy lapinkulta */
  effectlist=effectlistentry_new(effect_new(copy_new, params_37_copy_lapinkulta),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[LAPINKULTA];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
