/* assembly2002demo45.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* The end screen */
#include "assembly2002demo.h"

static void params_45_copy(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_45_START;
  if(time<0)
    time=0;

  if(time>=SONGPOSTOTIME(2, 32))
    data->alpha=(SONGPOSTOTIME(3, 6)-time)*191/SONGPOSTOTIME(1, 38);
}

static void params_45_verticalstretch(void *d, long time) {
  verticalstretch_data *data=(verticalstretch_data *)d;
  time-=PART_45_START;
  if(time<0)
    time=0;

  if(time>=SONGPOSTOTIME(2, 32)) {
    data->position=data->dest->height*cos((double)(time-SONGPOSTOTIME(2, 32))*M_PI/2/SONGPOSTOTIME(1, 38));
    data->length=data->dest->height-data->position;
  }
}

static void params_45_add(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_45_START;
  if(time<0)
    time=0;

  if(time/24>255)
    data->color=0;
  else 
    data->color=((255-time/24)<<24|0xffffff);
}

void part_45() {
  copy_data *copydata;
  verticalstretch_data *vsdata;
  add_data *adddata;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 3. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_45_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 2. Strech it */
  effectlist=effectlistentry_new(effect_new(verticalstretch_new,
					    params_45_verticalstretch),
				 effectlist);
  vsdata=(verticalstretch_data *)effectlist->effect->data;
  vsdata->dest=&screenbuffer;
  vsdata->position=0;
  vsdata->length=0;

  /* 1. Copy help background */
  effectlist=effectlistentry_new(effect_new(copy_new, params_45_copy),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[ENDSCREEN];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[ENDSCREEN]->width;
  copydata->sourceheight=pictures[ENDSCREEN]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=191;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
