/* horizontalstretch.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "effect.h"
#include "horizontalstretch.h"

void horizontalstretch_run(void *d, long time) {
  horizontalstretch_data *data=(horizontalstretch_data *)d;

  /* Get local copies of the parameters */
  unsigned long *dest=data->dest->data;
  int width=data->dest->width, height=data->dest->height;
  int position=data->position;
  int start, end, x, y;
  if(data->length>0) {
    start=position;
    end=position+data->length;
  } else {
    start=position+data->length;
    end=position;
  }

  for(y=0; y<height; y++) {
    for(x=start; x<end; x++)
      dest[x]=dest[position];
    dest+=width;
  }
}

void horizontalstretch_free(effect *effect) {
  free(effect->data);
}

void horizontalstretch_new(effect *effect) {
  effect->run=horizontalstretch_run;
  effect->new=horizontalstretch_new;
  effect->parameters=NULL;
  effect->freee=horizontalstretch_free;
  effect->data=(horizontalstretch_data *)calloc(sizeof(horizontalstretch_data), 1);
}
