/* verticalstretch.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "effect.h"
#include "verticalstretch.h"

void verticalstretch_run(void *d, long time) {
  verticalstretch_data *data=(verticalstretch_data *)d;

  /* Get local copies of the parameters */
  unsigned long *source=data->dest->data;
  unsigned long *dest=data->dest->data;
  int width=data->dest->width, height=data->dest->height;
  int position=data->position;
  int start, end, x, y;
  if(data->length>0) {
    start=position;
    end=position+data->length;
  } else {
    start=position+data->length;
    end=position;
  }

  source+=position*width;
  dest+=start*width;
  for(y=0; y<end-start; y++) {
    for(x=0; x<width; x++)
      *dest++=*source++;
    source-=width;
  }
}

void verticalstretch_free(effect *effect) {
  free(effect->data);
}

void verticalstretch_new(effect *effect) {
  effect->run=verticalstretch_run;
  effect->new=verticalstretch_new;
  effect->parameters=NULL;
  effect->freee=verticalstretch_free;
  effect->data=(verticalstretch_data *)calloc(sizeof(verticalstretch_data), 1);
}
