/* zoomrotate.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "effect.h"
#include "zoomrotate.h"

extern int sinus[1024];

void zoomrotate_run(void *d, long time) {
  zoomrotate_data *data=(zoomrotate_data *)d;
  int angle, dx, dy, width, height;
  unsigned int px, py, zoom;
  unsigned long x, y, *source, *dest;

  /* Get local copies of the parameters */
  angle=data->angle, dx=data->dx, dy=data->dy;
  px=data->px, py=data->py, zoom=data->zoom;
  source=data->source->data;
  dest=data->dest->data;
  width=data->dest->width;
  height=data->dest->height;

  dx=zoom*sinus[((angle>>16)+256)%1023]>>8;
  dy=zoom*sinus[angle>>16]>>8;
  px=256/2*0x10000+width/2*dx+height/2*dy;
  py=256/2*0x10000-width/2*dy+height/2*dx;
  px=px&0x00ffffff;
  py=py&0x00ffffff;
 
  for(y=0; y<height; y++) {
    for(x=0; x<width; x++) {
      *dest++=source[((py>>16)*256+(px>>16))];
      px-=dx;
      py+=dy;
      px=px&0x00ffffff;
      py=py&0x00ffffff;
    }
    px-=(-width*dx+dy);
    py+=(-width*dy-dx);
    px=px&0x00ffffff;
    py=py&0x00ffffff;
  }
}

void zoomrotate_free(effect *effect) {
  free(effect->data);
}

void zoomrotate_new(effect *effect) {
  effect->run=zoomrotate_run;
  effect->new=zoomrotate_new;
  effect->freee=zoomrotate_free;
  effect->data=(zoomrotate_data *)calloc(sizeof(zoomrotate_data), 1);
}
