/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3f;

public class ComicShape3D
extends Shape3D {
    private float[][] originalNormals = null;
    private float[][] texturCoord = null;
    private boolean hasAlreadyTextures = false;
    private GeomUpdaterComic updater;

    public ComicShape3D() {
    }

    public ComicShape3D(Shape3D shape3D) {
        Appearance appearance;
        super.duplicateNode((Node)shape3D, true);
        this.setCapability(12);
        this.setCapability(13);
        float[][] fArrayArray = new float[shape3D.numGeometries()][];
        this.texturCoord = new float[shape3D.numGeometries()][];
        this.originalNormals = new float[shape3D.numGeometries()][];
        int n = 0;
        while (n < shape3D.numGeometries()) {
            float[] fArray;
            Object[] objectArray;
            appearance = (GeometryArray)shape3D.getGeometry(n);
            int n2 = appearance.getVertexFormat();
            int n3 = n2 | 0x80 | 0x20;
            int n4 = appearance.getVertexCount();
            fArrayArray[n] = new float[n4 * 3];
            this.originalNormals[n] = new float[n4 * 3];
            this.texturCoord[n] = new float[n4 * 2];
            QuadArray quadArray = null;
            if (shape3D.getGeometry(n) instanceof QuadArray) {
                quadArray = new QuadArray(n4, n3);
            } else if (shape3D.getGeometry(n) instanceof TriangleArray) {
                quadArray = new TriangleArray(n4, n3);
            } else if (shape3D.getGeometry(n) instanceof TriangleStripArray) {
                objectArray = new int[((TriangleStripArray)shape3D.getGeometry(n)).getNumStrips()];
                ((TriangleStripArray)shape3D.getGeometry(n)).getStripVertexCounts((int[])objectArray);
                quadArray = new TriangleStripArray(n4, n3, (int[])objectArray);
            } else if (shape3D.getGeometry(n) instanceof TriangleFanArray) {
                objectArray = new int[((TriangleFanArray)shape3D.getGeometry(n)).getNumStrips()];
                ((TriangleFanArray)shape3D.getGeometry(n)).getStripVertexCounts((int[])objectArray);
                quadArray = new TriangleFanArray(n4, n3, (int[])objectArray);
            } else if (shape3D.getGeometry(n) instanceof IndexedTriangleArray) {
                quadArray = new IndexedTriangleArray(n4, n3, ((IndexedTriangleArray)shape3D.getGeometry(n)).getIndexCount());
            } else if (shape3D.getGeometry(n) instanceof IndexedTriangleFanArray) {
                objectArray = new int[((TriangleFanArray)shape3D.getGeometry(n)).getNumStrips()];
                ((IndexedTriangleFanArray)shape3D.getGeometry(n)).getStripIndexCounts((int[])objectArray);
                quadArray = new IndexedTriangleFanArray(n4, n3, ((IndexedTriangleFanArray)shape3D.getGeometry(n)).getIndexCount(), (int[])objectArray);
            } else if (shape3D.getGeometry(n) instanceof IndexedTriangleStripArray) {
                objectArray = new int[((TriangleStripArray)shape3D.getGeometry(n)).getNumStrips()];
                ((IndexedTriangleStripArray)shape3D.getGeometry(n)).getStripIndexCounts((int[])objectArray);
                quadArray = new IndexedTriangleStripArray(n4, n3, ((IndexedTriangleStripArray)shape3D.getGeometry(n)).getIndexCount(), (int[])objectArray);
            } else if (shape3D.getGeometry(n) instanceof PointArray) {
                quadArray = new PointArray(n4, n3);
            }
            objectArray = new float[n4 * 3];
            appearance.getCoordinates(0, objectArray);
            System.arraycopy(objectArray, 0, fArrayArray[n], 0, objectArray.length);
            quadArray.setCoordRefFloat(objectArray);
            quadArray.setCapability(19);
            quadArray.setCapability(21);
            if ((n2 & 0x20) != 0) {
                System.out.println("HAS ALREADY TEXTURES");
                this.hasAlreadyTextures = true;
                fArray = new float[2 * n4];
                appearance.getTextureCoordinates(0, 0, fArray);
                quadArray.setTexCoordRefFloat(0, fArray);
            } else {
                quadArray.setTexCoordRefFloat(0, this.texturCoord[n]);
            }
            if ((n2 & 2) != 0) {
                fArray = new float[3 * n4];
                appearance.getNormals(0, fArray);
                System.arraycopy(fArray, 0, this.originalNormals[n], 0, fArray.length);
                quadArray.setNormalRefFloat(fArray);
            }
            this.setGeometry((Geometry)quadArray, n);
            ++n;
        }
        appearance = this.getAppearance();
        TextureAttributes textureAttributes = new TextureAttributes(5, new Transform3D(), new Color4f(1.0f, 1.0f, 1.0f, 0.0f), 1);
        appearance.setTextureAttributes(textureAttributes);
        appearance.getMaterial().setLightingEnable(false);
        Color3f color3f = new Color3f();
        if (!this.hasAlreadyTextures) {
            appearance.getMaterial().getDiffuseColor(color3f);
            appearance.setTexture((Texture)this.buildTextures(color3f, 4));
        } else {
            appearance.setCapability(3);
            this.setCapability(14);
            this.setCapability(15);
        }
    }

    private Texture2D buildTextures(Color3f color3f, int n) {
        Texture2D texture2D = new Texture2D(1, 5, n, 1);
        BufferedImage bufferedImage = new BufferedImage(n, 1, 1);
        int n2 = 0;
        while (n2 < n) {
            float f = (float)(n2 + 2) / (float)n;
            int n3 = (int)(255.0f * color3f.x * f);
            int n4 = (int)(255.0f * color3f.y * f);
            int n5 = (int)(255.0f * color3f.z * f);
            if (n3 > 255) {
                n3 = 255;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            if (n5 > 255) {
                n5 = 255;
            }
            bufferedImage.setRGB(n2, 0, (n3 << 16) + (n4 << 8) + n5);
            ++n2;
        }
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, bufferedImage);
        texture2D.setImage(0, (ImageComponent)imageComponent2D);
        texture2D.setMagFilter(2);
        texture2D.setMinFilter(2);
        texture2D.setBoundaryModeS(4);
        texture2D.setBoundaryModeT(4);
        return texture2D;
    }

    public synchronized void updateShape(Transform3D transform3D, Vector3f vector3f) {
        if (this.updater == null && !this.hasAlreadyTextures) {
            this.updater = new GeomUpdaterComic(this.texturCoord[0], this.originalNormals[0]);
        }
        if (!this.hasAlreadyTextures) {
            this.updater.setUpdateData(transform3D, vector3f);
            GeometryArray geometryArray = (GeometryArray)this.getGeometry(0);
            geometryArray.updateData((GeometryUpdater)this.updater);
        }
    }
}

