/*
 * Decompiled with CFR 0.152.
 */
package com.mnstarfire.loaders3d;

import com.mnstarfire.loaders3d.FakeRandomAccess;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Helper3DS {
    private int lt;
    public boolean eof;
    private FakeRandomAccess Lt;

    public Helper3DS(InputStream inputStream) {
        this.Lt = new FakeRandomAccess(inputStream);
    }

    public int readByte() {
        try {
            return this.Lt.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            this.eof = true;
            return 0;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return 0;
        }
    }

    public int readShort() {
        try {
            this.lt = this.Lt.readUnsignedShort();
            return this.lt << 8 & 0xFF00 | this.lt >> 8 & 0xFF;
        }
        catch (EOFException eOFException) {
            this.eof = true;
            return 0;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return 0;
        }
    }

    public int readInt() {
        try {
            this.lt = this.Lt.readInt();
            return this.lt << 24 & 0xFF000000 | this.lt << 8 & 0xFF0000 | this.lt >> 8 & 0xFF00 | this.lt >> 24 & 0xFF;
        }
        catch (EOFException eOFException) {
            this.eof = true;
            return 0;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return 0;
        }
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while ((c = (char)this.Lt.readUnsignedByte()) != '\u0000') {
                stringBuffer.append(c);
            }
        }
        catch (EOFException eOFException) {
            this.eof = true;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return stringBuffer.toString();
    }

    public int getPosition() {
        return this.Lt.getFilePointer();
    }

    public void skip(int n) {
        try {
            if ((n -= 6) > 0) {
                int n2 = this.Lt.getFilePointer();
                this.Lt.seek(n2 + n);
            }
        }
        catch (EOFException eOFException) {
            this.eof = true;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

