/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import javazoom.jl.converter.DLkh;
import javazoom.jl.converter.RiffFile;
import javazoom.jl.converter.dLKh;

public class WaveFile
extends RiffFile {
    public static final int MAX_WAVE_CHANNELS = 2;
    private dLKh lth;
    private DLkh Lth = new DLkh(this);
    private long lTh = 0L;
    private int LTh = 0;

    public WaveFile() {
        this.lth = new dLKh(this);
        this.Lth.ckID = RiffFile.FourCC("data");
        this.Lth.ckSize = 0;
        this.LTh = 0;
    }

    public int OpenForWrite(String string, int n, short s, short s2) {
        byte[] byArray;
        if (string == null || s != 8 && s != 16 || s2 < 1 || s2 > 2) {
            return 4;
        }
        this.lth.data.Config(n, s, s2);
        int n2 = this.Open(string, 1);
        if (n2 == 0 && (n2 = this.Write(byArray = new byte[]{87, 65, 86, 69}, 4)) == 0) {
            n2 = this.Write(this.lth.header, 8);
            n2 = this.Write(this.lth.data.wFormatTag, 2);
            n2 = this.Write(this.lth.data.nChannels, 2);
            n2 = this.Write(this.lth.data.nSamplesPerSec, 4);
            n2 = this.Write(this.lth.data.nAvgBytesPerSec, 4);
            n2 = this.Write(this.lth.data.nBlockAlign, 2);
            n2 = this.Write(this.lth.data.nBitsPerSample, 2);
            if (n2 == 0) {
                this.lTh = this.CurrentFilePosition();
                n2 = this.Write(this.Lth, 8);
            }
        }
        return n2;
    }

    public int WriteData(short[] sArray, int n) {
        int n2 = n * 2;
        this.Lth.ckSize += n2;
        return super.Write(sArray, n2);
    }

    public int Close() {
        int n = 0;
        if (this.fmode == 1) {
            n = this.Backpatch(this.lTh, this.Lth, 8);
        }
        if (n == 0) {
            n = super.Close();
        }
        return n;
    }

    public int SamplingRate() {
        return this.lth.data.nSamplesPerSec;
    }

    public short BitsPerSample() {
        return this.lth.data.nBitsPerSample;
    }

    public short NumChannels() {
        return this.lth.data.nChannels;
    }

    public int NumSamples() {
        return this.LTh;
    }

    public int OpenForWrite(String string, WaveFile waveFile) {
        return this.OpenForWrite(string, waveFile.SamplingRate(), waveFile.BitsPerSample(), waveFile.NumChannels());
    }

    public long CurrentFilePosition() {
        return super.CurrentFilePosition();
    }
}

