/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.DlkHLh;
import javazoom.jl.decoder.DlkHlH;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.dlKhLh;

class DLkHLh
extends DlkHLh {
    protected int channel2_allocation;
    protected int channel2_scfsi;
    protected float channel2_scalefactor1;
    protected float channel2_scalefactor2;
    protected float channel2_scalefactor3;
    protected int[] channel2_codelength = new int[]{0};
    protected float[] channel2_factor = new float[]{0.0f};
    protected float[] channel2_samples;
    protected float[] channel2_c = new float[]{0.0f};
    protected float[] channel2_d = new float[]{0.0f};

    public DLkHLh(int n) {
        super(n);
        this.channel2_samples = new float[3];
    }

    public void read_allocation(Bitstream bitstream, Header header, Crc16 crc16) {
        int n = this.get_allocationlength(header);
        this.allocation = bitstream.get_bits(n);
        this.channel2_allocation = bitstream.get_bits(n);
        if (crc16 != null) {
            crc16.add_bits(this.allocation, n);
            crc16.add_bits(this.channel2_allocation, n);
        }
    }

    public void read_scalefactor_selection(Bitstream bitstream, Crc16 crc16) {
        if (this.allocation != 0) {
            this.scfsi = bitstream.get_bits(2);
            if (crc16 != null) {
                crc16.add_bits(this.scfsi, 2);
            }
        }
        if (this.channel2_allocation != 0) {
            this.channel2_scfsi = bitstream.get_bits(2);
            if (crc16 != null) {
                crc16.add_bits(this.channel2_scfsi, 2);
            }
        }
    }

    public void read_scalefactor(Bitstream bitstream, Header header) {
        super.read_scalefactor(bitstream, header);
        if (this.channel2_allocation != 0) {
            switch (this.channel2_scfsi) {
                case 0: {
                    this.channel2_scalefactor1 = dlKhLh.scalefactors[bitstream.get_bits(6)];
                    this.channel2_scalefactor2 = dlKhLh.scalefactors[bitstream.get_bits(6)];
                    this.channel2_scalefactor3 = dlKhLh.scalefactors[bitstream.get_bits(6)];
                    break;
                }
                case 1: {
                    this.channel2_scalefactor1 = this.channel2_scalefactor2 = dlKhLh.scalefactors[bitstream.get_bits(6)];
                    this.channel2_scalefactor3 = dlKhLh.scalefactors[bitstream.get_bits(6)];
                    break;
                }
                case 2: {
                    this.channel2_scalefactor2 = this.channel2_scalefactor3 = dlKhLh.scalefactors[bitstream.get_bits(6)];
                    this.channel2_scalefactor1 = this.channel2_scalefactor3;
                    break;
                }
                case 3: {
                    this.channel2_scalefactor1 = dlKhLh.scalefactors[bitstream.get_bits(6)];
                    this.channel2_scalefactor2 = this.channel2_scalefactor3 = dlKhLh.scalefactors[bitstream.get_bits(6)];
                }
            }
            this.prepare_sample_reading(header, this.channel2_allocation, 1, this.channel2_factor, this.channel2_codelength, this.channel2_c, this.channel2_d);
        }
    }

    public boolean read_sampledata(Bitstream bitstream) {
        boolean bl = super.read_sampledata(bitstream);
        if (this.channel2_allocation != 0) {
            if (this.groupingtable[1] != null) {
                int n = bitstream.get_bits(this.channel2_codelength[0]);
                n += n << 1;
                float[] fArray = this.channel2_samples;
                float[] fArray2 = this.groupingtable[1];
                int n2 = 0;
                int n3 = n;
                fArray[n2] = fArray2[n3];
                fArray[++n2] = fArray2[++n3];
                fArray[++n2] = fArray2[++n3];
            } else {
                this.channel2_samples[0] = (float)((double)((float)bitstream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                this.channel2_samples[1] = (float)((double)((float)bitstream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                this.channel2_samples[2] = (float)((double)((float)bitstream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
            }
        }
        return bl;
    }

    public boolean put_next_sample(int n, DlkHlH dlkHlH, DlkHlH dlkHlH2) {
        boolean bl = super.put_next_sample(n, dlkHlH, dlkHlH2);
        if (this.channel2_allocation != 0 && n != 1) {
            float f = this.channel2_samples[this.samplenumber - 1];
            if (this.groupingtable[1] == null) {
                f = (f + this.channel2_d[0]) * this.channel2_c[0];
            }
            f = this.groupnumber <= 4 ? (f *= this.channel2_scalefactor1) : (this.groupnumber <= 8 ? (f *= this.channel2_scalefactor2) : (f *= this.channel2_scalefactor3));
            if (n == 0) {
                dlkHlH2.input_sample(f, this.subbandnumber);
            } else {
                dlkHlH.input_sample(f, this.subbandnumber);
            }
        }
        return bl;
    }
}

