/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.DLKhLh;
import javazoom.jl.decoder.DlKhLh;
import javazoom.jl.decoder.DlkHlH;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.dLKhLh;
import javazoom.jl.decoder.dlKhLh;

class dlkHLh
implements FrameDecoder {
    protected Bitstream stream;
    protected Header header;
    protected DlkHlH filter1;
    protected DlkHlH filter2;
    protected Obuffer buffer;
    protected int which_channels;
    protected int mode;
    protected int num_subbands;
    protected dlKhLh[] subbands;
    protected Crc16 crc = new Crc16();

    public void create(Bitstream bitstream, Header header, DlkHlH dlkHlH, DlkHlH dlkHlH2, Obuffer obuffer, int n) {
        this.stream = bitstream;
        this.header = header;
        this.filter1 = dlkHlH;
        this.filter2 = dlkHlH2;
        this.buffer = obuffer;
        this.which_channels = n;
    }

    public void decodeFrame() {
        this.num_subbands = this.header.number_of_subbands();
        this.subbands = new dlKhLh[32];
        this.mode = this.header.mode();
        this.createSubbands();
        this.readAllocation();
        this.readScaleFactorSelection();
        if (this.crc != null || this.header.checksum_ok()) {
            this.readScaleFactors();
            this.readSampleData();
        }
    }

    protected void createSubbands() {
        if (this.mode == 3) {
            int n = 0;
            while (n < this.num_subbands) {
                this.subbands[n] = new DlKhLh(n);
                ++n;
            }
        } else if (this.mode == 1) {
            int n = 0;
            while (n < this.header.intensity_stereo_bound()) {
                this.subbands[n] = new DLKhLh(n);
                ++n;
            }
            while (n < this.num_subbands) {
                this.subbands[n] = new dLKhLh(n);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.num_subbands) {
                this.subbands[n] = new DLKhLh(n);
                ++n;
            }
        }
    }

    protected void readAllocation() {
        int n = 0;
        while (n < this.num_subbands) {
            this.subbands[n].read_allocation(this.stream, this.header, this.crc);
            ++n;
        }
    }

    protected void readScaleFactorSelection() {
    }

    protected void readScaleFactors() {
        int n = 0;
        while (n < this.num_subbands) {
            this.subbands[n].read_scalefactor(this.stream, this.header);
            ++n;
        }
    }

    protected void readSampleData() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.header.mode();
        do {
            int n2 = 0;
            while (n2 < this.num_subbands) {
                bl = this.subbands[n2].read_sampledata(this.stream);
                ++n2;
            }
            do {
                n2 = 0;
                while (n2 < this.num_subbands) {
                    bl2 = this.subbands[n2].put_next_sample(this.which_channels, this.filter1, this.filter2);
                    ++n2;
                }
                this.filter1.calculate_pcm_samples(this.buffer);
                if (this.which_channels != 0 || n == 3) continue;
                this.filter2.calculate_pcm_samples(this.buffer);
            } while (!bl2);
        } while (!bl);
    }
}

