/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;

public class Player {
    private int lth = 0;
    private Bitstream Lth;
    private Decoder lTh;
    private AudioDevice LTh;
    private boolean ltH = false;
    private boolean LtH = false;
    private int lTH = 0;

    public Player(InputStream inputStream) throws JavaLayerException {
        this(inputStream, null);
    }

    public Player(InputStream inputStream, AudioDevice audioDevice) throws JavaLayerException {
        this.Lth = new Bitstream(inputStream);
        this.lTh = new Decoder();
        if (audioDevice != null) {
            this.LTh = audioDevice;
        } else {
            FactoryRegistry factoryRegistry = FactoryRegistry.systemRegistry();
            this.LTh = factoryRegistry.createAudioDevice();
        }
        this.LTh.open(this.lTh);
    }

    public void play() throws JavaLayerException {
        this.play(Integer.MAX_VALUE);
    }

    public boolean play(int n) throws JavaLayerException {
        AudioDevice audioDevice;
        boolean bl = true;
        while (n-- > 0 && bl) {
            bl = this.decodeFrame();
        }
        if (!bl && (audioDevice = this.LTh) != null) {
            audioDevice.flush();
            Player player = this;
            synchronized (player) {
                this.LtH = !this.ltH;
                this.close();
            }
        }
        return bl;
    }

    public synchronized void close() {
        AudioDevice audioDevice = this.LTh;
        if (audioDevice != null) {
            this.ltH = true;
            this.LTh = null;
            audioDevice.close();
            this.lTH = audioDevice.getPosition();
            try {
                this.Lth.close();
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean isComplete() {
        return this.LtH;
    }

    public int getPosition() {
        int n = this.lTH;
        AudioDevice audioDevice = this.LTh;
        if (audioDevice != null) {
            n = audioDevice.getPosition();
        }
        return n;
    }

    protected boolean decodeFrame() throws JavaLayerException {
        try {
            AudioDevice audioDevice = this.LTh;
            if (audioDevice == null) {
                return false;
            }
            Header header = this.Lth.readFrame();
            if (header == null) {
                return false;
            }
            SampleBuffer sampleBuffer = (SampleBuffer)this.lTh.decodeFrame(header, this.Lth);
            Player player = this;
            synchronized (player) {
                audioDevice = this.LTh;
                if (audioDevice != null) {
                    audioDevice.write(sampleBuffer.getBuffer(), 0, sampleBuffer.getBufferLength());
                }
            }
            this.Lth.closeFrame();
        }
        catch (RuntimeException runtimeException) {
            throw new JavaLayerException("Exception decoding audio frame", runtimeException);
        }
        return true;
    }
}

