/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioStream;

class HQModule
extends Thread
implements Player {
    protected boolean potetenErVarm = false;
    protected int doubleCounter = 0;
    SourceDataLine dline;
    protected boolean fallback = false;
    BufferedInputStream buffin;
    DataInputStream din;
    protected byte[] title;
    protected byte[] type;
    protected int number_of_channels;
    protected Sample[] samples;
    protected int module_length;
    protected int number_of_patterns;
    protected int[] order;
    float scale = 2.0f;
    protected Note[] pattern_data;
    int playback_samplerate;
    int playback_samplebits;
    int maxbufferwrite;
    byte[] writebuffer;
    byte[] writebuffer2;
    int buffer_update_delay_ms;
    int buffer_length_ms;
    PipedOutputStream dataline;
    int bpm;
    int speed;
    float mod_update_frequency;
    float mod_update_delay_ms;
    InputStream inputstream;
    DataInputStream modstream;
    AudioStream as;
    AudioData ad;
    AudioDataStream ads;
    PipedInputStream pipeIn;
    PipedOutputStream pipeOut;
    DataOutputStream dataOut;
    protected Display disp;
    int tick;
    int row;
    int order_position;
    int pattern;
    float mod_time;
    float mod_update_time;
    long start_time;
    volatile boolean stop_playing;
    volatile boolean started;
    volatile boolean pause;
    protected String filename;
    Channel[] channels;
    boolean[] row_effects_not_supported = new boolean[16];
    boolean[] tick_effects_not_supported = new boolean[16];
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public HQModule(URL uRL, int n, Display display) {
        super("moduleThread : " + uRL.getFile());
        this.disp = display;
        this.filename = uRL.getFile();
        this.pattern_data = null;
        this.LoadModule(uRL);
        this.playback_samplerate = 22100;
        this.playback_samplebits = 8;
        this.setPriority(10);
        this.bpm = 125;
        this.speed = 6;
        this.mod_update_frequency = 2.0f * (float)this.bpm / 5.0f;
        this.mod_update_delay_ms = 1000.0f / this.mod_update_frequency;
        this.tick = this.speed;
        this.row = 0;
        this.order_position = 0;
        this.pattern = this.order[this.order_position];
        this.stop_playing = false;
        this.started = false;
        this.channels = new Channel[this.number_of_channels];
        int n2 = 0;
        while (n2 < this.number_of_channels) {
            this.channels[n2] = new Channel();
            ++n2;
        }
        this.buffer_update_delay_ms = 500;
        this.buffer_length_ms = n;
        this.maxbufferwrite = (int)((float)this.playback_samplerate * ((float)this.buffer_update_delay_ms + (float)this.buffer_length_ms) / 1000.0f);
        this.writebuffer = new byte[2 * this.maxbufferwrite];
        this.logg("delay between each mod update tick in ms: " + this.mod_update_delay_ms);
        this.logg("buffer update delay in ms: " + this.buffer_update_delay_ms);
        this.logg("buffer write size: " + this.maxbufferwrite);
        this.logg("Starting with pattern " + this.pattern);
        int n3 = 0;
        while (n3 < this.row_effects_not_supported.length) {
            this.row_effects_not_supported[n3] = false;
            this.tick_effects_not_supported[n3] = false;
            ++n3;
        }
    }

    private void UpdateModule() {
        ++this.tick;
        if (this.tick >= this.speed) {
            if (this.row >= 64) {
                ++this.order_position;
                if (this.order_position >= this.module_length) {
                    this.logg("restarting mod");
                    this.SetPosition(0);
                }
                this.pattern = this.order[this.order_position];
                this.row = 0;
                this.logg("pattern " + this.pattern);
            }
            int n = 0;
            while (n < this.number_of_channels) {
                Note note = this.GetNote(this.pattern, this.row, n);
                if (note.note_number != -1) {
                    this.logg(note.GetNoteSymbol() + " " + note.sample_number + " row " + this.row + " freq " + note.period_frequency + " note number " + note.note_number);
                }
                if (note.sample_number > 0) {
                    this.channels[n].sample = this.GetSample(note.sample_number - 1);
                    this.channels[n].sample_volume = this.channels[n].sample.GetVolume();
                }
                if (note.note_number >= 0) {
                    this.channels[n].note = note;
                    int n2 = this.channels[n].note.get_frequency(this.channels[n].sample.GetFineTune());
                    this.channels[n].sample_frequency = (int)(7159090.5f / (float)(n2 << 1));
                    this.channels[n].sample_delta = (float)this.channels[n].sample_frequency / (float)this.playback_samplerate;
                    this.channels[n].sample_offset = 0.0f;
                }
                this.channels[n].effect_number = note.effect_number;
                this.channels[n].effect_param = note.effect_param;
                if (note.effect_number != 0 || note.effect_param != 0) {
                    this.ProcessRowEffects(n);
                }
                ++n;
            }
            this.logg();
            this.tick = 0;
            ++this.row;
        } else {
            int n = 0;
            while (n < this.number_of_channels) {
                if (this.channels[n].effect_number != 0 || this.channels[n].effect_param != 0) {
                    this.ProcessTickEffects(n);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.started = true;
        this.logg("Starter audiostream");
        long l = this.start_time = System.currentTimeMillis();
        this.mod_time = 0.0f;
        this.mod_update_time = this.mod_update_delay_ms;
        float f = 1.0f / ((float)this.playback_samplerate / 1000.0f);
        this.logg("time delta: " + f);
        this.UpdateModule();
        while (!this.stop_playing) {
            int n = 2048;
            try {
                if (this.dline != null) {
                    n = this.dline.available();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = n;
            this.doubleCounter = 0;
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n7 < this.number_of_channels) {
                    if (this.channels[n7].sample != null && this.channels[n7].sample_offset < (float)this.channels[n7].sample.GetLength()) {
                        n4 = this.channels[n7].sample.sample_data[(int)this.channels[n7].sample_offset];
                        n4 *= this.channels[n7].sample_volume;
                        n4 >>= 6;
                        if (n7 == 0 || n7 == 3) {
                            n5 += n4;
                        } else {
                            n6 += n4;
                        }
                        this.channels[n7].UpdateSamplePosition();
                    }
                    ++n7;
                }
                n4 = n5 >> 1;
                byte by = (byte)(n6 >> 1);
                this.writebuffer[n3] = n4;
                this.writebuffer[n3 + 1] = by;
                this.mod_time += f;
                if (this.mod_time >= this.mod_update_time) {
                    this.UpdateModule();
                    this.mod_update_time += this.mod_update_delay_ms;
                }
                n3 += 2;
            }
            try {
                this.dline.write(this.writebuffer, 0, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                long l2 = (l += (long)(this.buffer_update_delay_ms >> 1)) - System.currentTimeMillis();
                Thread.sleep(Math.max(0L, l2));
                if (!this.pause) continue;
                HQModule hQModule = this;
                synchronized (hQModule) {
                    while (this.pause) {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void ProcessRowEffects(int n) {
        int n2 = this.channels[n].effect_number;
        int n3 = this.channels[n].effect_param;
        switch (n2) {
            case 0: {
                this.channels[n].arpeggio_counter = 0;
                break;
            }
            case 12: {
                this.channels[n].sample_volume = n3;
                if (this.channels[n].sample_volume <= 64) break;
                this.channels[n].sample_volume = 64;
                break;
            }
            case 15: {
                if (n3 < 32) {
                    this.speed = n3;
                    break;
                }
                this.bpm = n3;
                this.mod_update_frequency = 2.0f * (float)this.bpm / 5.0f;
                this.mod_update_delay_ms = 1000.0f / this.mod_update_frequency;
                break;
            }
            default: {
                this.row_effects_not_supported[n2] = true;
            }
        }
    }

    void ProcessTickEffects(int n) {
        int n2 = this.channels[n].effect_number;
        int n3 = this.channels[n].effect_param;
        switch (n2) {
            case 0: {
                int n4 = this.channels[n].arpeggio_counter;
                int n5 = 0;
                if (++n4 > 2) {
                    n4 = 0;
                }
                if (n4 == 0) {
                    n5 = 0;
                } else if (n4 == 1) {
                    n5 = n3 >> 4;
                } else if (n4 == 2) {
                    n5 = n3 % 16;
                }
                this.logg("arp step: " + n5);
                int n6 = this.channels[n].note.get_frequency(n5, this.channels[n].sample.GetFineTune());
                this.channels[n].sample_frequency = (int)(7159090.5f / (float)(n6 << 1));
                this.channels[n].sample_delta = (float)this.channels[n].sample_frequency / (float)this.playback_samplerate;
                this.channels[n].arpeggio_counter = n4;
                break;
            }
            case 1: {
                this.channels[n].sample_frequency = this.channels[n].sample_frequency - n3 > 113 ? (this.channels[n].sample_frequency -= n3) : 113;
                this.channels[n].sample_delta = (float)this.channels[n].sample_frequency / (float)this.playback_samplerate;
                break;
            }
            case 2: {
                this.channels[n].sample_frequency += n3;
                this.channels[n].sample_delta = (float)this.channels[n].sample_frequency / (float)this.playback_samplerate;
                break;
            }
            case 3: {
                int n7 = this.channels[n].note.get_frequency();
                if (n7 > this.channels[n].sample_frequency) {
                    this.channels[n].sample_frequency += n3;
                } else if (n7 < this.channels[n].sample_frequency) {
                    this.channels[n].sample_frequency -= n3;
                }
                this.channels[n].sample_delta = (float)this.channels[n].sample_frequency / (float)this.playback_samplerate;
                break;
            }
            case 10: {
                int n8 = this.channels[n].sample_volume;
                if (n3 < 16) {
                    if ((n8 -= n3) < 0) {
                        n8 = 0;
                    }
                } else if (n3 >= 16 && n3 < 32 && (n8 += n3 - 15) > 64) {
                    n8 = 64;
                }
                this.channels[n].sample_volume = n8;
                break;
            }
            default: {
                this.tick_effects_not_supported[n2] = true;
            }
        }
    }

    private void InitializeSound() {
        try {
            this.UpdateModule();
            Thread thread = new Thread("playerThread : " + this.filename){

                public void run() {
                    try {
                        Thread.sleep(500L);
                        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
                        AudioFormat audioFormat = new AudioFormat(HQModule.this.playback_samplerate, HQModule.this.playback_samplebits, 2, true, false);
                        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = HQModule.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
                        HQModule.this.dline = (SourceDataLine)AudioSystem.getLine(info);
                        HQModule.this.dline.open(audioFormat, HQModule.this.maxbufferwrite);
                        HQModule.this.dline.start();
                        HQModule.this.disp.loaderInfo("Hi-Fi sound enabled!");
                    }
                    catch (Exception exception) {
                        HQModule.this.disp.loaderInfo("Error locating audiodevice!");
                    }
                }
            };
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Sample GetSample(int n) {
        return this.samples[n];
    }

    public Note GetNote(int n, int n2, int n3) {
        return this.pattern_data[(n << 6) * this.number_of_channels + n2 * this.number_of_channels + n3];
    }

    private void LoadModule(URL uRL) {
        try {
            int n;
            this.inputstream = uRL.openConnection().getInputStream();
            this.modstream = new DataInputStream(this.inputstream);
            this.logg("mark and reset methods supported: " + this.modstream.markSupported());
            if (this.modstream.markSupported()) {
                this.modstream.mark(this.inputstream.available());
                this.modstream.skip(1080L);
                this.type = new byte[4];
                this.modstream.read(this.type, 0, this.type.length);
                this.logg(new String(this.type));
                if (!new String(this.type).equals(new String("M.K."))) {
                    this.logg("This is not a protracker module!");
                } else {
                    this.logg("loading protracker module");
                }
                this.modstream.reset();
            }
            this.number_of_channels = 4;
            this.title = new byte[20];
            this.modstream.read(this.title, 0, this.title.length);
            this.logg(new String(this.title));
            int n2 = 0;
            while (n2 < 20) {
                if (this.title[n2] == 0) {
                    this.title[n2] = 32;
                }
                ++n2;
            }
            this.samples = new Sample[31];
            int n3 = 0;
            while (n3 < 31) {
                this.samples[n3] = new Sample();
                this.samples[n3].LoadSampleHeader(this.modstream);
                this.logg("Sample " + n3 + ": " + this.samples[n3].GetName());
                this.logg(" length     : " + this.samples[n3].GetLength());
                this.logg(" fine tune  : " + this.samples[n3].GetFineTune());
                this.logg(" volume     : " + this.samples[n3].GetVolume());
                this.logg(" loop start : " + this.samples[n3].GetLoopStart());
                this.logg(" loop length: " + this.samples[n3].GetLoopLength());
                ++n3;
            }
            this.logg("");
            this.module_length = this.modstream.readUnsignedByte();
            this.logg("LQModule length: " + this.module_length);
            this.modstream.skipBytes(1);
            this.order = new int[128];
            this.number_of_patterns = 0;
            int n4 = 0;
            while (n4 < 128) {
                this.order[n4] = this.modstream.readUnsignedByte();
                if (this.order[n4] > this.number_of_patterns) {
                    this.number_of_patterns = this.order[n4];
                }
                ++n4;
            }
            ++this.number_of_patterns;
            this.modstream.skipBytes(4);
            int n5 = (this.number_of_channels << 6) * this.number_of_patterns;
            this.pattern_data = new Note[n5];
            int n6 = 0;
            while (n6 < n5) {
                this.pattern_data[n6] = new Note();
                ++n6;
            }
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.number_of_patterns) {
                n = 0;
                while (n < 64 * this.number_of_channels) {
                    int n9;
                    int n10 = this.modstream.readUnsignedByte();
                    int n11 = this.modstream.readUnsignedByte();
                    int n12 = this.modstream.readUnsignedByte();
                    int n13 = this.modstream.readUnsignedByte();
                    this.pattern_data[n7].sample_number = (n10 & 0xF0) + (n12 >> 4);
                    this.pattern_data[n7].effect_number = n12 & 0xF;
                    this.pattern_data[n7].effect_param = n13;
                    this.pattern_data[n7].period_frequency = n9 = ((n10 & 0xF) << 8) + n11;
                    this.pattern_data[n7].assign_note_number(n9);
                    ++n7;
                    ++n;
                }
                ++n8;
            }
            n = 0;
            while (n < 31) {
                this.samples[n].LoadSampleData(this.modstream);
                ++n;
            }
            this.logg("Samples loaded.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int GetSpeed() {
        return this.speed;
    }

    public int GetBPM() {
        return this.bpm;
    }

    public int GetNumberOfChannels() {
        return this.number_of_channels;
    }

    public String GetTitle() {
        return new String(this.title);
    }

    public int GetLength() {
        return this.module_length;
    }

    public String GetSampleName(int n) {
        if (this.samples[n - 1] != null) {
            return this.samples[n - 1].GetName();
        }
        return null;
    }

    public void PrintEffectsNotSupported() {
        int n = 0;
        while (n < this.row_effects_not_supported.length) {
            if (!this.row_effects_not_supported[n] || this.tick_effects_not_supported[n]) {
                // empty if block
            }
            ++n;
        }
    }

    public int GetPosition() {
        int n;
        long l = System.currentTimeMillis() - this.start_time;
        float f = this.mod_time - (float)l;
        int n2 = (int)(f / this.mod_update_delay_ms / (float)this.speed);
        this.logg("lag(ms): " + f);
        this.logg("lag(rows): " + n2);
        if (this.row - n2 >= 0) {
            n = this.order_position;
        } else {
            n = this.order_position - 1;
            if (n < 0) {
                n = this.module_length - 1;
            }
        }
        return n;
    }

    public int GetRow() {
        return this.row;
    }

    public synchronized void stopModule() {
        this.stop_playing = true;
        this.notify();
    }

    public synchronized void pause() {
        this.pause = true;
    }

    public synchronized void play() {
        if (this.pause) {
            this.pause = false;
            this.notify();
        } else if (!this.started) {
            this.start();
            this.InitializeSound();
            this.started = true;
        }
    }

    public void logg(String string) {
    }

    public void logg() {
    }

    public void SetPosition(int n) {
        this.order_position = n;
        this.pattern = this.order[this.order_position];
        this.tick = this.speed;
        this.row = 0;
        this.mod_time = 0.0f;
        this.mod_update_time = 0.0f;
    }

    public void Rewind() {
        this.SetPosition(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

