// ihmiset.inc 
//   -ihmisaiheisia objekteja
//   -ilp0/piAstro 2001
//------------------------------------------------------//
//                     < LIPUT >                        //
#declare l_detaljit = 1;
#declare l_valot    = 1;
#declare l_testaus  = 0; // oltava 0!!! 
//------------------------------------------------------//
//                    < VAKIOT >                        //
background { color rgb 1 }
#declare paa_r    = 0.12;
#declare torso_Y  = 0.6;
#declare torso_r1 = 0.25;
#declare torso_r2 = 0.2;
#declare kasi_Y   = 1.0;
#declare kasi_r1  = 0.09;
#declare kasi_r2  = 0.06;
#declare jalka_Y  = 1.9;
#declare jalka_r1 = 0.10;
#declare jalka_r2 = 0.07;
//------------------------------------------------------//
//                  < VRIT >                           //    
#declare v_iho           = color rgb <0.9, 0.8, 0.1>;
#declare v_musta         = color rgb <0.4, 0.4, 0.4>;
#declare v_farkut        = color rgb <0.2, 0.4, 0.8>;
#declare v_suorat_housut = color rgb <0.5, 0.5, 0.5>;
//------------------------------------------------------//
//                < TEKSTUURIT >                        //     
#declare t_iho = 
  texture { 
    pigment { v_iho }
    normal { wrinkles 0.4 scale 0.001 }
    finish { ambient 0.4 diffuse 0.3 }}

#declare t_suorat_housut =
  texture {
    pigment { v_musta }
    finish { ambient 0.5 diffuse 0.2 crand 0.1 }}

#declare t_farkut =
  texture {
    pigment { v_farkut }
    normal { wrinkles 0.6 scale 0.001 }
    finish { ambient 0.4 diffuse 0.3 crand 0.2 }}    
//------------------------------------------------------//  
//                   < MUODOT >                         // 
#declare m_hattu =
  union {
    cylinder {
      <0, 0, 0> 
      <0, 0.01, 0>, 0.25 }
    cylinder { 
      <0, 0, 0>
      <0, 0.10, 0>, 0.12 }
      rotate z*-15
      translate y*(jalka_Y+torso_Y+0.2)}

#declare m_paa =
  difference {  
    union { 
      sphere { <0, 0, 0>, paa_r 
               scale <1, 1.2, 1> }
      sphere { <-paa_r+0.03, 0, 0>, 0.03 
               scale <1.2, 1, 1> }}
    sphere { <-paa_r, 0.06, 0.06>, 0.04 
             scale <1, 0.7, 1.1> }
    sphere { <-paa_r, 0.06, -0.06>, 0.04 
             scale <1, 0.7, 1.1> }
    translate y*(jalka_Y+torso_Y+0.2) }

#declare m_torso =
  union {
    intersection { 
      cone { 
        <0, torso_Y, 0>, torso_r1 
        <0, 0, 0> torso_r2
        scale <0.7, 1, 1> }
      sphere { 
        <0, 0.3, 0>, 
        torso_Y-0.3 }}
    union { 
      sphere { <0, -0.2, 0.1>, 0.15 }
      sphere { <0, -0.2, -0.1>, 0.15 }
      bounded_by { 
        box { 
          <-0.15, -0.31, -0.19>
          <0.25, 0.25, 0.19> }}
      translate y*0.1 }
    superellipsoid { 
      <0.6, 0.6> 
      scale <0.16, 0.17, 0.30> 
      translate <0, torso_Y-0.15, 0> }
    cone { 
      <0, torso_Y, 0>, 0.08
      <0, torso_Y+0.15>, 0.07 }
    translate y*jalka_Y }

#declare m_v_kasi =
  union { 
    cone { <0, 0, 0>, kasi_r1
           <0, -kasi_Y/2,0>, (kasi_r1+kasi_r2)/2 
           rotate <10, 0, 25> }
    cone { <0, 0, 0>, (kasi_r1+kasi_r2)/2 
           <0, -kasi_Y/2, 0>, kasi_r2 
           rotate <0, 0, -25>
           translate <0.22, -0.4, -0.1> }
    translate <0, torso_Y-0.05, -0.3> 
    scale 0.8
    translate y*jalka_Y+0.05 }

#declare m_o_kasi =
  union { 
    cone { <0, 0, 0>, kasi_r1
           <0, -kasi_Y/2,0>, (kasi_r1+kasi_r2)/2 
           rotate <-10, 0, -8> }
    cone { <0, 0, 0>, (kasi_r1+kasi_r2)/2 
           <0, -kasi_Y/2, 0>, kasi_r2 
           rotate <0, 0, -39>
           translate <-0.02, -0.4, 0.1> }
    translate <0, torso_Y-0.05, 0.3> 
    scale 0.8
    translate y*jalka_Y+0.05 }

#declare m_v_jalka =
  union { 
    cone { <0, 0, 0>, jalka_r1
           <0, -jalka_Y/2+0.4,0>, (jalka_r1+jalka_r2)/2 
           rotate <5, 0, -25> 
           translate <0, 0, 0.13> }
    cone { <0, 0, 0>, (jalka_r1+jalka_r2)/2 
           <0, -jalka_Y/2+0.4, 0>, jalka_r2 
           rotate <0, 0, -5>
           translate <-0.22, -0.45, 0.09> }
    superellipsoid { 
      <0.5, 0.5> 
      scale <0.15, 0.04, 0.06>
      translate <-0.34, -1.0, 0.1> }
    translate <0, jalka_Y-0.05, -0.3> 
    }

#declare m_o_jalka =
  union { 
    cone { <0, 0, 0>, jalka_r1
           <0, -jalka_Y/2+0.4,0>, (jalka_r1+jalka_r2)/2 
           rotate <-5, 0, 15> 
           translate <0, 0, -0.13> }
    cone { <0, 0, 0>, (jalka_r1+jalka_r2)/2 
           <0, -jalka_Y/2+0.4, 0>, jalka_r2 
           rotate <0, 0, 25>
           translate <0.14, -0.45, -0.09> }
    superellipsoid { 
      <0.5, 0.5> 
      scale <0.15, 0.04, 0.06> 
      rotate z*25
      translate <0.34, -1.0, -0.1> }
    translate <0, jalka_Y-0.05, 0.3> 
    }                           
//------------------------------------------------------//  
//                   < OBJEKTIT >                       //
#declare o_kavelija1 = 
  union {
    object { m_paa texture { t_iho }}
    object { m_torso texture { t_suorat_housut }}
    object { m_v_kasi texture { t_farkut }}
    object { m_o_kasi texture { t_farkut }}
    object { m_v_jalka texture { t_suorat_housut }}
    object { m_o_jalka texture { t_suorat_housut }}
    object { m_hattu pigment { v_musta }}
    texture { t_iho }
    scale 1
    translate y*-0.85 }

//------------------------------------------------------//
//                 < TESTAUS KUVA >                     //
#if (l_testaus)           
  camera {
    location <-3, 2, 3> 
    look_at <0, 2, 0> }
  light_source { 
    <10, 1, 10>
    color rgb <1, 1, 1> }
  light_source {
    <10, 1, -10> 
    color rgb <1, 1, 1> }
  light_source { 
    <-10, 1, 10>
    color rgb <1, 1, 1> }
  light_source {
    <-10, 1, -10> 
    color rgb <1, 1, 1> }      
  plane { 
    y, 0 
    pigment { color rgb 0.9}}
  object { o_kavelija1 }  
#end






         