// This program converts from beat timing to absolute timing (in
// seconds). The input is the first column of the input file (*.SRC).
// The input file is copied to the output (*.CTL) so that the values
// in the first column are converted to seconds.

// Each input line is checked by valid () to find out if it has
// any meaningful data. If you insert comment lines in the *.SRC
// files, be sure that they do not contain numbers or periods!

// The input and the beat files are read in parallel, scanning the
// beat file (*.T) until the matching value is found. The file position
// tells the corresponding absolute time. The beat file must be
// previously created from tempo file (*.TEM) by the "beattime"
// program. The input values must be monotonically increasing.

#include <stdio.h>
#include <math.h>
#include <string.h>



#define DPI (2.0 * 3.141592653587973238)



double srate  = 44100.0;



long valid (char *buf, long bcol, long ecol) {

  long i;

  for (i = bcol ; i <= ecol ; i++) {
    if (buf [i] == '\n') return (0L);
    if (strchr ("0123456789.", buf [i]) != NULL) return (1L); }
  return (0L); }



int main (int argc, char *argv []) {

  double srate;
  FILE   *sf, *tf, *bf;
  long   i, lc, rejc, bcol, ecol;
  float  sbeat, cbeat;
  char   buf [1024];

  printf ("Time stamp converter 1.0\n\n");

  if (argc < 6) {
    printf ("Use: b2t <sourcefile> <bcol> <ecol> <targetfile> <beatfile> "
            "[samplerate]\n");
    return (1); }

  sf = fopen (argv [1], "r");
  if (sf == NULL) {
    printf ("Cannot open source file '%s'.\n", argv [1]);
    return (2); }

  sscanf (argv [2], "%ld", &bcol);

  sscanf (argv [3], "%ld", &ecol);

  tf = fopen (argv [4], "w");
  if (tf == NULL) {
    printf ("Cannot open target file '%s'.\n", argv [4]);
    return (3); }

  bf = fopen (argv [5], "rb");
  if (bf == NULL) {
    printf ("Cannot open beat file '%s'.\n", argv [5]);
    return (4); }

  srate = 44100.0;
  if (argc >= 6) sscanf (argv [6], "%lf", &srate);

  rejc = 0L;
  fread (&cbeat, sizeof (float), 1, bf);
  for (lc = 0 ; 1 ; lc++) {
    memset (buf, 0, 256);
    fgets (buf, 256, sf);
    if (feof (sf)) break;
    if (valid (buf, bcol, ecol)) {
      sscanf (buf + bcol, "%f", &sbeat);
      while (cbeat < sbeat) {
        fread (&cbeat, sizeof (float), 1, bf);
        if (feof (bf)) break; }
      for (i = 0 ; (i < bcol) && (buf [i] != '\0') && (buf [i] != '\n') ; i++)
        putc (buf [i], tf);
      fprintf (tf,
               "%12.6lf %s",
               (double) (ftell (bf) / sizeof (float)) / srate,
               buf + ecol + 1 ); }
    else rejc++; }

  fclose (bf);
  fclose (tf);
  fclose (sf);

  printf ("%ld rejected lines\n", rejc);

  return (0); }
