// This function reads a single column of the input file (*.CTL)
// and writes its values interpolated with a time resolution of one
// sound sample into a separate file.

// The column boundaries are defined by variables vbcol and vecol.
// The left edge of the time column is given in tcol.

// This program is applied multiple times on the input file to
// interpolate all the input columns (excluding the time column).
// Use file name typifiers according to the needs of the sound
// generation program which uses the output of this program.
// The use of the input and output data is documented in the
// sound generator file comments.

#include <stdio.h>
#include <math.h>

#define BUFLEN 256
#define STRLEN (BUFLEN - 4)



FILE *argfopen (char *a, char *m) {
  FILE *f;
  f = fopen (a, m);
  if (f == NULL) printf ("Cannot open file '%s'.\n", a);
  return (f); }



int main (int argc, char *argv []) {

  double t, ta, tb, va, vb, srate;
  float  v;
  FILE   *cf, *df;
  long   i, tcol, vbcol, vecol;
  long   init = 1;
  char   buf [BUFLEN];

  printf ("Control function interpolator 1.1\n\n");

  if (argc < 6) {
    printf ("Use: cfi <controlfile> <datafile> <tcol> <vbcol> <vecol> "
            "[samplerate]\n");
    return (1); }

  if ((cf = argfopen (argv [1], "r"))  == NULL) return (2);
  if ((df = argfopen (argv [2], "wb")) == NULL) return (3);
  sscanf (argv [3], "%ld", &tcol);
  sscanf (argv [4], "%ld", &vbcol);
  sscanf (argv [5], "%ld", &vecol);
  srate = 44100.0;
  if (argc >= 7) sscanf (argv [6], "%lf", &srate);

  while (1) {
    ta = tb; va = vb;
    for (i = 0 ; i < BUFLEN ; i++) buf [i] = 0;
    fgets (buf, STRLEN, cf);
    if (feof (cf)) break;
    sscanf (buf + tcol, "%lf", &tb);
    for (i = vbcol ; i <= vecol ; i++) {
      if ((buf [i] & 0x007f) > 32) break; }
    if (i <= vecol) sscanf (buf + vbcol, "%lf", &vb);
    if (init == 1) {init = 0; t = tb; continue;}
    while (t < tb) {
      v = (float) (va + (t - ta) / (tb - ta) * (vb - va));
      fwrite (&v, sizeof (float), 1, df);
      t += (1.0 / srate); } }

  fclose (df);
  fclose (cf);

  return (0); }
