// This program duplicates the samples of a monophonic WAV file,
// creating a stereophonic file with all sounds panned to the center.
// The header block is updated to reflect the stereo mode.

#include <stdio.h>
#include <memory.h>



int main (int argc, char *argv []) {

  FILE   *src,       // Source file
         *tgt;       // Target file
  long   i,
         lv,         // Temporary value
         bc;         // Byte count
  short  iv;         // Temporary value
  char   hdr [44];   // WAV header buffer

  if (argc < 3) {
    printf ("Use: stereo <infile> <outfile>\n");
    return (1); }

  src = fopen (argv [1], "rb");
  if (src == NULL) {
    printf ("Cannot open input file '%s'\n", argv [1]);
    return (2); }

  tgt = fopen (argv [2], "wb");
  if (tgt == NULL) {
    printf ("Cannot open output file '%s'\n", argv [2]);
    return (3); }

  fread (hdr, 44, 1, src);

  memcpy (&lv, hdr + 40L, sizeof (long));
  bc  = lv;
  lv *= 2L;
  memcpy (hdr + 40L, &lv, sizeof (long));
  lv += 36L;
  memcpy (hdr + 4L, &lv, sizeof (long));

  iv = 2;
  memcpy (hdr + 22, &iv, sizeof (short));

  memcpy (&lv, hdr + 28, sizeof (long));
  lv *= 2L;
  memcpy (hdr + 28, &lv, sizeof (long));

  iv = 4;
  memcpy (hdr + 32, &iv, sizeof (short));

  fwrite (hdr, 44, 1, tgt);

  for (i = 0L ; i < bc / 2L ; i++) {
    fread  (&iv, sizeof (short), 1, src);
    fwrite (&iv, sizeof (short), 1, tgt);
    fwrite (&iv, sizeof (short), 1, tgt); }

  fclose (tgt);
  fclose (src);

  return (0); }
