// Diffuse echo impulse response generator, hardcoded for single hall at
// sample rate 44100 Hz. 3 s reverberation time. Stereo output.

// An insertion window 2000 samples wide moves along the time axis.
// In this window impulses are inserted at random positions and
// the window is moved forward once for each insertion at a slowly
// decreasing speed to increase the density of the samples towards the end.
// Each insertion is written to the output file as a pair of numbers, the
// insertion point index and the sample value, whose amplitude is random
// but multiplied with an amplitude envelope function. The output is
// an ASCII file, containing first the left channel, then the
// right channel.

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <math.h>
#include <string.h>
#include <values.h>

#define DPI           (2.0 * PI)
#define HPI           (PI / 2.0)
#define SRATE         44100.0



int main (int argc, char *argv []) {

  double didx,   // Insertion zone center
         inc;    // Insertion zone center increment
  FILE   *tgt;   // Output file pointer
  long   sn,     // The number of the current sample
         sc,     // Total number of samples
         idx;    // Insertion point

  if (argc < 2) {
    printf ("Use: asmd <outputfile>\n");
    printf ("\n");
    return (1); }

  tgt = fopen (argv [1], "w");
  if (tgt == NULL) {
    printf ("Cannot open output file '%s'\n", argv [1]);
    return (2); }

  // Previously estimated, fixed number of impulses

  sc = 4855L;

  // Left channel generation

  inc = 60.0;
  didx = 2000.0;
  for (sn = 0L ; sn < sc ; sn++) {
    idx = (long) (didx + 1000.0 * ((double) random () / (double) MAXINT));
    if (idx < 2000L) continue;
    fprintf (tgt,
             "L   %6ld   %6d\n",
             idx,
             (short) (  32767.0
                        * ((double) random () / (double) MAXINT)
                        * exp (-0.0000522128139 * didx)
                        * (- 2000.0 / (didx + 1000.0) + 1.0) ) );
    didx += (40.0 + inc);
    inc *= 0.995; }

  // Right channel generation

  inc = 60.0;
  didx = 2000.0;
  for (sn = 0L ; sn < sc ; sn++) {
    idx = (long) (didx + 1000.0 * ((double) random () / (double) MAXINT));
    if (idx < 2000L) continue;
    fprintf (tgt,
             "R   %6ld   %6d\n",
             idx,
             (short) (  32767.0
                        * ((double) random () / (double) MAXINT)
                        * exp (-0.0000522128139 * didx)
                        * (- 2000.0 / (didx + 1000.0) + 1.0) ) );
    didx += (40.0 + inc);
    inc *= 0.995; }

  fprintf (tgt, "END\n");

  fclose (tgt);

  return (0); }
