// This is a beat timing calculator. It takes a list of spline nodes
// (*.TEM, time in beats versus tempo in beats per second) and outputs
// another list (*.T) which contains the beat index for each sound
// sample. The output is used to bind together the beats and
// the corresponding absolute time by the other programs.

// The concept of "beat" is interpreted more loosely than in the
// MIDI world, and is often used to refer a shorter amount of time.

// If your tempo spline has more than 65536 nodes, you must modify
// this porgram.

#include <stdio.h>
#include <math.h>



double srate  = 44100.0;
double tbeat  [65536];
double tempo  [65536];



int main (int argc, char *argv []) {

  double phase,        // Interpolation point between two beats
         ctempo;       // The tempo of the current sample
  FILE   *f;
  float  b;            // The beat value of the current sample
  long   i,
         tempoitems;   // Total number of spline nodes
  char   buf [256];

  printf ("Beat timing calculator 1.0\n\n");

  if (argc < 3) {
    printf ("Use: beattime <tempofile> <beatfile> [samplerate]\n");
    return (1); }

  if (argc >= 4) sscanf (argv [4], "%lf", &srate);

  /* Load tempo file */

  f = fopen (argv [1], "r");
  if (f == NULL) {
    printf ("Cannot open tempo file '%s'.\n", argv [1]);
    return (1); }
  for (i = 0 ; 1 ; i++) {
    fgets (buf, 80, f);
    if (feof (f)) break;
    sscanf (buf, "%lf %lf", tbeat + i, tempo + i); }
  tempoitems = i;
  fclose (f);

  /* Write beat file */

  f = fopen (argv [2], "wb");
  if (f == NULL) {
    printf ("Cannot open beat file '%s'.\n", argv [2]);
    return (2); }

  for (i = 0 ; i < tempoitems - 1 ; i++) {
    for (b = tbeat [i] ; b < tbeat [i + 1] ; ) {
      fwrite (&b, sizeof (float), 1, f);
      phase = (b - tbeat [i]) / (tbeat [i + 1] - tbeat [i]);
      ctempo = tempo [i] + phase * (tempo [i + 1] - tempo [i]);
      b += (ctempo / srate); } }
  b = tbeat [tempoitems - 1];
  fwrite (&b, sizeof (float), 1, f);

  printf ("%ld samples, %lf seconds\n",
          ftell (f) / sizeof (float),
          (double) (ftell (f) / sizeof (float)) / srate );

  fclose (f);

  return (0); }
