// This file combines separate left and right channel WAV files into
// a stereophonic WAV file.

#include <stdio.h>
#include <memory.h>
#include <math.h>



int main (int argc, char *argv []) {

  double llvl,       // Left channel level
         rlvl;       // Right channel level
  FILE   *srcl,      // input left channel file
         *srcr,      // Input right channel file
         *tgt;       // Output file
  long   i,
         bc,         // Final byte count
         bcl,        // Left channel byte count
         bcr,        // Right channel byte count
         lv;         // Temporary value
  short  iv;         // Temporary value
  char   hdr [44];   // WAV file header

  if (argc < 6) {
    printf ("Use: interl <leftinfile> <rightinfile> "
            "<left_dB> <right_dB> <outfile>\n");
    return (1); }

  srcl = fopen (argv [1], "rb");
  if (srcl == NULL) {
    printf ("Cannot open left channel input file '%s'\n", argv [1]);
    return (2); }

  srcr = fopen (argv [2], "rb");
  if (srcr == NULL) {
    printf ("Cannot open right channel input file '%s'\n", argv [2]);
    fclose (srcl);
    return (3); }

  sscanf (argv [3], "%lf", &llvl); llvl = pow (10.0, llvl / 20.0);
  sscanf (argv [4], "%lf", &rlvl); rlvl = pow (10.0, rlvl / 20.0);

  tgt = fopen (argv [5], "wb");
  if (tgt == NULL) {
    printf ("Cannot open output file '%s'\n", argv [3]);
    return (4); }

  fread (hdr, 44, 1, srcl);

  memcpy (&bcl, hdr + 40L, sizeof (long));

  fread (hdr, 44, 1, srcr);

  memcpy (&bcr, hdr + 40L, sizeof (long));

  if (bcl > bcr) bc = bcl; else bc = bcr;

  bc *= 2L;
  memcpy (hdr + 40L, &bc, sizeof (long));

  bc += 36L;
  memcpy (hdr + 4L, &bc, sizeof (long));

  iv = 2;
  memcpy (hdr + 22L, &iv, sizeof (short));

  memcpy (&lv, hdr + 28L, sizeof (long));
  lv *= 2L;
  memcpy (hdr + 28L, &lv, sizeof (long));

  iv = 4;
  memcpy (hdr + 32L, &iv, sizeof (short));

  fwrite (hdr, 44, 1, tgt);

  for (i = 0 ; i < bc / 2L ; i++) {
    if (fread  (&iv, sizeof (short), 1, srcl) != 1) iv = 0;
    iv = (short) (llvl * (double) iv);
    fwrite (&iv, sizeof (short), 1, tgt);
    if (fread  (&iv, sizeof (short), 1, srcr) != 1) iv = 0;
    iv = (short) (rlvl * (double) iv);
    fwrite (&iv, sizeof (short), 1, tgt); }

  fclose (tgt);
  fclose (srcr);
  fclose (srcl);

  return (0); }
