#include <SDL/SDL.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.1416
#define ANCHO 320
#define ALTO 240


int makeColor (int r, int g, int b)
{
   return( b| (g<<8)| (r<<16) );

}

void putPixel(int x,int y,int color,SDL_Surface * pantalla)
{
           unsigned int * ppantalla = (unsigned int *)((unsigned )pantalla->pixels+y*pantalla->pitch);
           ppantalla[x]= color ; //(unsigned (makeColor(r,g,b)));          
  
}
int getPixel(int x,int y,SDL_Surface * pantalla)
{
          unsigned int * ppantalla = (unsigned int *)((unsigned )pantalla->pixels+y*pantalla->pitch);
          return(ppantalla[x]);  	
}
void colorearPantalla(int color, SDL_Surface * pantalla)
{
   for (int y=0;  y< ALTO; y++)
   {
      unsigned int * ppantalla = (unsigned int *)((unsigned )pantalla->pixels+y*pantalla->pitch);
      for (int x=0; x < ANCHO; x++)
         ppantalla[x]= color;
   }      
       
          
} 
/* PLASMA */

void colorearMemoria(int color, int* memoria,int memancho , int memalto)
{	
   for (int y=0;  y< memalto; y++)
   {
      for (int x=0; x < memancho; x++)
         memoria[y*memancho+x]= color;
   }
}
void colorearMemoria2c(int color,int color2, int* memoria,int memancho , int memalto)
{	
   for (int y=0;  y< memalto; y++)
   {
      for (int x=0; x < memancho; x++)
         if (x&1)
         memoria[y*memancho+x]= color;
         else
         memoria[y*memancho+x]= color2;
         
   }
}
void cargarMemoria(SDL_Surface* pantalla, int *memoria, int memancho , int memalto, int x, int y)
{
           for (int j=0; j< memalto; j++)
           {
           unsigned int * ppantalla = (unsigned int *)((unsigned )pantalla->pixels+(y+j)*pantalla->pitch);
             for (int i=0; i< memancho; i++)
              {
                         ppantalla[i+x]= memoria[j*memancho+i];           
              }
            }
}

int* cargarImagen(char* path, int memancho , int memalto)
{
           FILE* fp = fopen(path,"rb");
           unsigned char r,g,b;
           int *mem=(int *)malloc(memancho*memalto*sizeof(int));
           for (int j=0; j< memalto; j++)
           {
             for (int i=0; i< memancho; i++)
              {
                 fread(&r,1,1,fp);
                 fread(&g,1,1,fp);
                 fread(&b,1,1,fp);
                 mem[j*memancho+i]= makeColor(r,g,b);
     
              }
            }
            fclose(fp);
            return mem;
}

int* initPlasma()
{
   int * mimemoria;
   mimemoria= (int *)malloc(256*256*sizeof(int));
   colorearMemoria(makeColor(255,255,255),mimemoria,256,256);
     
   return mimemoria;

}
void endplasma(int* mimemoria)
{
   free(mimemoria);
}

void conviertePantalla(SDL_Surface* pantalla, int* image, int* tabla, int tiempodist, int tiempoang)
{
        
   for (int y=0;y < ALTO; y++)
      for (int x=0;x < ANCHO; x++)
      {     
         int angulo = (tabla[y*ANCHO+x] & 0x0000ff00) >>8;
         int distancia = (tabla[y*ANCHO+x] & 0x000000ff);
         distancia = (distancia + tiempodist)&0xff;
         angulo = (angulo + tiempoang)&0xff;
         putPixel(x,y,image[(distancia<<8) +angulo],pantalla);
      }

}
int* calculaTablaTunel(int pantancho,int pantalto)
{
   int* tabla;
   float dist;/*modulo del vector*/
   float angulo;
   tabla = (int *)malloc(pantancho*pantalto*4);
   for (int j=0; j< pantalto; j++)
      for (int i=0; i< pantancho; i++)
      {
         float xrelativa; /* coordenado x respecto el centro de pantalla*/
         float yrelativa; /* coordenado y respecto el centro de pantalla*/
         xrelativa = (float)(i-pantancho/2)/(pantancho/2);
         yrelativa = (float) (j-pantalto/2)/(pantalto/2);
         dist = 10.0f/sqrt(xrelativa*xrelativa +  yrelativa*yrelativa);
         angulo = atan2(xrelativa,yrelativa);
         int ang= int(128+((128*angulo)/PI));
         int dst = (int)(dist * 5.0f); 
         
         tabla[j*pantancho+i] = dst + (ang<<8); /* guardamos el angulo en el segundo bit de la tabla y en el primero la distancia*/
      }
      return tabla;

}
int* calculaTablaTunelPifiaDos(int pantancho,int pantalto,float centrox,float centroy)
{
   int* tabla;
   float dist;/*modulo del vector*/
   float angulo;
   tabla = (int *)malloc(pantancho*pantalto*4);
   for (int j=0; j< pantalto; j++)
      for (int i=0; i< pantancho; i++)
      {
         float xrelativa; /* coordenado x respecto el centro de pantalla*/
         float yrelativa; /* coordenado y respecto el centro de pantalla*/
         xrelativa = centrox + (float)(i-pantancho/2)/(pantancho/2);
         yrelativa = centroy + (float) (j-pantalto/2)/(pantalto/2);
         dist = 10.0f/sqrt((xrelativa*xrelativa +  yrelativa*yrelativa) +2);
         angulo = atan2(xrelativa,yrelativa);
         int ang= int(128+((128*angulo)/PI));
         int dst = (int)(dist * 5.0f); 
         
         tabla[j*pantancho+i] = dst + (ang<<8); /* guardamos el angulo en el segundo bit de la tabla y en el primero la distancia*/
      }
      return tabla;

}
int* calculaTablaTunelPifiaUno(int pantancho,int pantalto)
{
   int* tabla;
   float dist;/*modulo del vector*/
   float angulo;
   tabla = (int *)malloc(pantancho*pantalto*4);
   for (int j=0; j< pantalto; j++)
      for (int i=0; i< pantancho; i++)
      {
         float xrelativa; /* coordenado x respecto el centro de pantalla*/
         float yrelativa; /* coordenado y respecto el centro de pantalla*/
         xrelativa = (float)(i-pantancho/2)/(pantancho/2);
         yrelativa = (float) (j-pantalto/2)/(pantalto/2);
         dist = 10.0f/sqrt(xrelativa*xrelativa +  yrelativa*yrelativa+6);
         angulo = atan2(xrelativa,yrelativa);
         int ang= int(128+((128*angulo)/PI));
         int dst = (int)(dist * 5.0f); 
         
         tabla[j*pantancho+i] = dst + (ang<<8); /* guardamos el angulo en el segundo bit de la tabla y en el primero la distancia*/
      }
      return tabla;

}

/*END PLASMA*/



int main ()
{
      	SDL_Surface *pantalla;
        SDL_Init(SDL_INIT_VIDEO);
	pantalla =SDL_SetVideoMode(ANCHO,ALTO,32,SDL_SWSURFACE );       
        int* mimem;
        mimem = cargarImagen("image.raw",256,256);
        int* table = calculaTablaTunel(ANCHO,ALTO);
        int ta=0;
        
        int td=0;

        for (int i=0; i< 160; i++)
        {
             conviertePantalla(pantalla,mimem,table,td+=3,ta--);
             SDL_UpdateRect(pantalla,0,0,0,0);
          
        }
        for (int i=0; i< 80; i++)
        {
             conviertePantalla(pantalla,mimem,table,td+2,ta--);
             SDL_UpdateRect(pantalla,0,0,0,0);
        }
        
        table =  calculaTablaTunelPifiaUno(ANCHO,ALTO);
        
        for (int i=0; i< 160; i++)
        {
             conviertePantalla(pantalla,mimem,table,td+=2,ta--);
             SDL_UpdateRect(pantalla,0,0,0,0);
          
        }
       
        table = calculaTablaTunelPifiaDos(ANCHO,ALTO,0,-1);
       
        for (int i=0; i< 160; i++)
        {
             conviertePantalla(pantalla,mimem,table,td+=2,ta--);
             SDL_UpdateRect(pantalla,0,0,0,0);
          
        }
        SDL_Delay(5000);
        endplasma(mimem);
        
        SDL_Quit();
	       
        return 0;
}
