///////////////////////////////////////////////////////////////////////////////////////////////////
//
// kilometer years from france - a demo
//
// Copyright (C) 2002 Camilla Drefvenborg <elmindreda@home.se>
// Copyright (C) 2002 Ronny Gripenborn <rymdknark@yahoo.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

class DemoPrism;
class DemoImage;
class DemoBlobs;
class DemoStars;
class DemoWords;
class DemoHyper;
class DemoLocks;
class DemoRonny;
class DemoFlash;

///////////////////////////////////////////////////////////////////////////////////////////////////

class Demo : public ThServerObject, public ThEffectObject
{
public:
																		Demo(void);
																		~Demo(void);
	bool															open(void);
	bool															recieve(ThMessage* message);
	bool															update(float deltaTime);
	bool															render(void);
private:
	bool															loadSolid(unsigned int texture, const char* fileName, bool mipmap = false);
	bool															loadAlpha(unsigned int texture, const char* fileName, bool mipmap = false);
	ThPtr<DemoPrism>									m_prism;
	ThPtr<DemoImage>									m_hypercube;
	ThPtr<DemoImage>									m_presents;
	ThPtr<DemoImage>									m_wrong;
	ThPtr<DemoImage>									m_iwin;
	ThPtr<DemoBlobs>									m_blobs;
	ThPtr<DemoImage>									m_kilometer[2];
	ThPtr<DemoStars>									m_stars;
	ThPtr<DemoWords>									m_words;
	ThPtr<DemoHyper>									m_hyper;
	ThPtr<DemoLocks>									m_locks;
	ThPtr<DemoRonny>									m_ronny;
	ThPtr<DemoFlash>									m_flash;
	ThPtr<DemoImage>									m_gazman[2];
	ThPtr<DemoImage>									m_elmindreda[2];
	ThPtr<DemoImage>									m_cybear[2];
	ThPtr<DemoImage>									m_salome[2];
	ThPtr<DemoImage>									m_kuntakinte[2];
	ThPtr<DemoImage>									m_rymdknark[2];
	ThBlock<unsigned int>							m_textures;
};

class DemoPrism : public ThEffectObject
{
public:
																		DemoPrism(void);
																		~DemoPrism(void);
	bool															open(void);
	void															signal(void);
	bool															update(float deltaTime);
	bool															render(void);
private:
	unsigned int											m_mode;
	float															m_depth;
	float															m_alpha;
	float															m_angle;
	unsigned int											m_list;
};

class DemoImage : public ThEffectObject
{
public:
																		DemoImage(unsigned int texture, const ThArea& area, bool blend = false);
																		~DemoImage(void);
	bool															open(void);
	bool															update(float deltaTime);
	bool															render(void);
private:
	unsigned int											m_texture;
	ThArea														m_area;
	bool															m_blend;
};

class DemoBlobs : public ThEffectObject
{
public:
																		DemoBlobs(void);
																		~DemoBlobs(void);
	bool															open(void);
	void															signal(unsigned int type);
	bool															update(float deltaTime);
	bool															render(void);
private:
	struct Blob
	{
		ThVector3												m_position;
		ThVector3												m_vector;
		ThVector3												m_scale;
		float														m_speed;
	};
	bool															m_light;
	bool															m_wire;
	bool															m_twist;
	bool															m_stop;
	float															m_time;
	ThBlock<Blob>											m_blobs;
};

class DemoStars : public ThEffectObject
{
public:
																		DemoStars(unsigned int texture);
																		~DemoStars(void);
	bool															open(void);
	void															signal(void);
	bool															update(float deltaTime);
	bool															render(void);
private:
	unsigned int											m_mode;
	float															m_time;
	float															m_size;
	unsigned int											m_count;
	unsigned int											m_texture;
	ThBlock<ThVector2>								m_positions;
};

class DemoWords : public ThEffectObject
{
public:
																		DemoWords(unsigned int* textures);
																		~DemoWords(void);
	bool															open(void);
	void															signal(void);
	bool															update(float deltaTime);
	bool															render(void);
private:
	struct Word
	{
		unsigned int										m_index;
		ThVector3												m_vector;
		unsigned int										m_texture;
	};
	unsigned int											m_mode;
	float															m_time;
	ThBlock<Word>											m_words;
	ThBlock<ThVector3>								m_positions;
	unsigned int*											m_textures;
};

class DemoHyper : public ThEffectObject
{
public:
																		DemoHyper(void);
																		~DemoHyper(void);
	bool															open(void);
	void															signal(void);
	bool															update(float deltaTime);
	bool															render(void);
private:
	unsigned int											m_mode;
	float															m_time;
};

class DemoLocks : public ThEffectObject
{
public:
																		DemoLocks(unsigned int* textures);
																		~DemoLocks(void);
	bool															open(void);
	void															signal(void);
	bool															update(float deltaTime);
	bool															render(void);
private:
	float															m_speed;
	unsigned int											m_index;
	float															m_angles[4];
	bool															m_static[4];
	unsigned int*											m_textures;
};

class DemoRonny : public ThEffectObject
{
public:
																		DemoRonny(void);
																		~DemoRonny(void);
	bool															open(void);
	void															signal(void);
	bool															update(float deltaTime);
	bool															render(void);
private:
	struct Object
	{
		ThBlock<ThVector2>							m_points;
	};
	float															m_scale;
	float															m_delay;
	unsigned int											m_count;
	unsigned int											m_index;
	ThBlock<Object>										m_objects;
	Object														m_object;
};

class DemoFlash : public ThEffectObject
{
public:
																		DemoFlash(unsigned int* textures, unsigned int count);
																		~DemoFlash(void);
	bool															open(void);
	void															signal(void);
	bool															update(float deltaTime);
	bool															render(void);
private:
	float															m_time;
	bool															m_single;
	unsigned int											m_index;
	unsigned int											m_count;
	unsigned int*											m_textures;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
