///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <ThCore.h>

#include <windows.h>

#include <cstdio>
#include <cstdlib>
#include <cstring>

///////////////////////////////////////////////////////////////////////////////////////////////////

void* AllocateBlock(unsigned int size)
{
	THASSERT(size > 0, "Cannot allocate zero size memory block.");

	return malloc(size);
}

void* ResizeBlock(void* block, unsigned int size)
{
	return realloc(block, size);
}

void ReleaseBlock(void* block)
{
	free(block);
}

///////////////////////////////////////////////////////////////////////////////////////////////////

const char* GetPlatformName(void)
{
	static char platformName[THERESA_BUFFER_SIZE];

	char version[THERESA_BUFFER_SIZE];

	OSVERSIONINFO osvi;

	memset(&osvi, 0, sizeof(OSVERSIONINFO));
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

	if (!GetVersionEx(&osvi))
		return "<<noname>>";

	strcpy(platformName, "Windows");

	if (osvi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
	{
		if (osvi.dwMinorVersion)
		{
			if (osvi.dwMinorVersion == 10)
			{
				strcat(platformName, " 98");

        if (osvi.szCSDVersion[1] == 'A')
          strcat(platformName, "SE");
				else if (osvi.szCSDVersion[0] != '\0')
				{
					strcat(platformName, " ");
					strcat(platformName, osvi.szCSDVersion);
				}
			}
			else if (osvi.dwMinorVersion == 90)
				strcat(platformName, " Me");
			else
				strcat(platformName, " 9x family");
		}
		else
		{
			strcat(platformName, " 95");

			if (osvi.szCSDVersion[1] == 'C')
				strcat(platformName, " OSR2");
			else if (osvi.szCSDVersion[0] != '\0')
			{
				strcat(platformName, " ");
				strcat(platformName, osvi.szCSDVersion);
			}
		}
	}
	else if (osvi.dwPlatformId == VER_PLATFORM_WIN32_NT)
	{
		if (osvi.dwMajorVersion == 4)
			strcat(platformName, " NT");
		else if (osvi.dwMajorVersion == 5)
		{
			if (osvi.dwMinorVersion)
			{
				if (osvi.dwMinorVersion == 1)
					strcat(platformName, " XP");
				else
					strcat(platformName, " XP family");
			}
			else
				strcat(platformName, " 2000");
		}
		else
			strcat(platformName, " NT family");

#ifdef OSVERSIONINFOEX

		OSVERSIONINFOEX osviex;
		memset(&osviex, 0, sizeof(OSVERSIONINFOEX));
		osviex.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);

		if (GetVersionEx((OSVERSIONINFO*) &osviex))
    {
      if (osviex.wProductType == VER_NT_WORKSTATION)
      {
        if (osviex.wSuiteMask & VER_SUITE_PERSONAL)
          strcat(platformName, " Home Edition");
        else
          strcat(platformName, " Professional");
      }
      else if (osviex.wProductType == VER_NT_SERVER)
      {
        if (osviex.wSuiteMask & VER_SUITE_DATACENTER)
          strcat(platformName, " DataCenter Server");
        else if (osviex.wSuiteMask & VER_SUITE_ENTERPRISE)
          strcat(platformName, " Advanced Server");
        else
          strcat(platformName, " Server");
      }
    }

#endif /* OSVERSIONINFOEX */

		if (osvi.dwMajorVersion == 4)
		{
			_snprintf(version, sizeof(version), " version %u.%u", osvi.dwMajorVersion, osvi.dwMinorVersion);
			strcat(platformName, version);
		}

		if (osvi.szCSDVersion[0] != '\0')
		{
			strcat(platformName, " ");
			strcat(platformName, osvi.szCSDVersion);
		}

		_snprintf(version, sizeof(version), " (Build %u)", osvi.dwBuildNumber);
		strcat(platformName, version);
	}

	return platformName;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef THERESA_DEBUG_BUILD

//! \note This function may not use \b any system code.
bool Assert(const char* expression, const char* message, const char* fileName, unsigned int line)
{
	static char buffer[THERESA_BUFFER_SIZE];

	if (_snprintf(buffer, sizeof(buffer), "Assertion failed!%s%sExpression: %s%sFile: %s%sLine: %u%s%s%s", THERESA_NEWLINE, THERESA_NEWLINE, expression, THERESA_NEWLINE, fileName, THERESA_NEWLINE, line, THERESA_NEWLINE, THERESA_NEWLINE, message) < 0)
		buffer[sizeof(buffer) - 1] = '\0';

	OutputDebugString(buffer);
	OutputDebugString(THERESA_NEWLINE);

	int result = MessageBox(GetActiveWindow(), buffer, "Theresa", MB_ICONERROR | MB_ABORTRETRYIGNORE);

	if (result == IDABORT)
		exit(0);

	if (result == IDIGNORE)
		return false;

	return true;
}

#endif /* THERESA_DEBUG_BUILD */

///////////////////////////////////////////////////////////////////////////////////////////////////
