///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THERROR_H
#define THERESA_THERROR_H
///////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef THERESA_SMALL_BUILD

class ThErrorDialog : public ThDialog
{
public:
// constructors
																		ThErrorDialog(const char* message, bool request);
protected:
// callbacks
	BOOL															initialize(HWND control);
private:
// data
	bool															m_request;
	ThString													m_message;
};

#endif /*THERESA_SMALL_BUILD*/

//-------------------------------------------------------------------------------------------------

class ThError : public IThError
{
public:
// constructors
																		ThError(void);
																		~ThError(void);
// methods
	bool															open(void);
	void															close(void);
// interface methods
	void															write(const char* name, const char* format, ...);
	void															display(const char* name, const char* format, ...);
	bool															request(const char* name, const char* format, ...);
private:
// data
	HANDLE														m_file;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THERROR_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
