///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THSTRING_H
#define SHARED_THSTRING_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThString
{
public:
// constructors
																		ThString(void);
																		ThString(unsigned int size);
																		ThString(const char* string);
																		ThString(const ThString& string);
																		~ThString(void);
// methods
	void															allocate(unsigned int size);
	void															resize(unsigned int size);
	void															release(void);
	void															releaseExtra(void);
	void															copy(const char* string);
	const char*												copy(const char* string, unsigned int length);
	const char*												copyLine(const char* string);
	const char*												copyToken(const char* string, const char* separators = NULL);
	void															append(const char* string);
	void															format(const char* format, ...);
	void															empty(void);
	unsigned int											length(void) const;
	unsigned int											hash(unsigned int length = 0) const;
	unsigned int											hashNoCase(unsigned int length = 0) const;
	bool															equals(const char* string) const;
	int																compare(const char* string) const;
	bool															equalsNoCase(const char* string) const;
	int																compareNoCase(const char* string) const;
	int																convertToInt(void) const;
	float															convertToFloat(void) const;
	char*															find(char c);
	const char*												find(char c) const;
	char*															find(const char* string);
	const char*												find(const char* string) const;
	char*															reverseFind(char c);
	const char*												reverseFind(char c) const;
	void															makeUpper(void);
	void															makeLower(void);
	void															reverse(void);
	void															trimLeft(const char* pattern);
	void															trimRight(const char* pattern);
// static methods
	static void												append(char* data, const char* string);
	static void												formatS(char* data, const char* format, ...);
	static void												formatS(char* data, unsigned int size, const char* format, ...);
	static void												empty(char* data);
	static unsigned int								length(const char* data);
	static unsigned int								hash(const char* data, unsigned int length = 0);
	static unsigned int								hashNoCase(const char* data, unsigned int length = 0);
	static void												copy(char* data, const char* string);
	static const char*								copy(char* data, const char* string, unsigned int length);
	static const char*								copyLine(char* data, const char* string);
	static const char*								copyToken(char* data, const char* string, const char* separators = NULL);
	static bool												equals(const char* data, const char* string);
	static int												compare(const char* data, const char* string);
	static bool												equalsNoCase(const char* data, const char* string);
	static int												compareNoCase(const char* data, const char* string);
	static int												convertToInt(const char* data);
	static float											convertToFloat(const char* data);
	static char*											find(char* data, char c);
	static const char*								find(const char* data, char c);
	static char*											find(char* data, const char* string);
	static const char*								find(const char* data, const char* string);
	static char*											reverseFind(char* data, char c);
	static const char*								reverseFind(const char* data, char c);
	static void												makeUpper(char* data);
	static void												makeLower(char* data);
	static void												reverse(char* data);
	static void												trimLeft(char* data, const char* pattern);
	static void												trimRight(char* data, const char* pattern);
// operators
																		operator char* (void);
																		operator const char* (void) const;
	ThString&													operator = (const char* string);
	ThString&													operator = (const ThString& string);
// attributes
	bool															isEmpty(void) const;
	char*															getData(void);
	const char*												getData(void) const;
	unsigned int											getSize(void) const;
private:
// data
	ThBlock<char>											m_data;
// static data
	static const unsigned int					m_primes[16];
};

//-------------------------------------------------------------------------------------------------

class ThStringItem : public ThString, public ThListItem<ThStringItem>
{
public:
// constructors
																		ThStringItem(void);
																		ThStringItem(unsigned int size);
																		ThStringItem(const char* string);
// operators
	ThStringItem&											operator = (const char* string);
	ThStringItem&											operator = (const ThString& string);
	ThStringItem&											operator = (const ThStringItem& string);
};

//-------------------------------------------------------------------------------------------------

class ThStringList : public ThItemList<ThStringItem>
{
public:
// methods
	ThStringItem*											find(const char* pattern);
	const ThStringItem*								find(const char* pattern) const;
	ThStringItem*											findExact(const char* string);
	const ThStringItem*								findExact(const char* string) const;
	ThStringItem*											findNoCase(const char* string);
	const ThStringItem*								findNoCase(const char* string) const;
};

///////////////////////////////////////////////////////////////////////////////////////////////////

#include "ThString.inl"

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THSTRING_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
