
/*
 * Sota 2002 - Surprise fast compo
 * Objectif : diminuer la taille d'un exe
 *
 * Les gain en taille on principalement t fait sur du sabrage
 * du code original. J'ai vir tous les tests d'IO et tous les
 * tests de retour de fonction. J'ai aussi vir toutes les chaines
 * de caractere hard codes.
 * Enfin, l'optim la plus significative a t de virer le fprintf
 * et le fscanf (du coup, je deviens completement dependant de la
 * source qui doit forcement etre du 640x400x255). A la place du
 * fprintf, j'ecris donc directement la chaine et a la place du 
 * fscanf, je saute le header et je hardcode les valeurs.
 * J'ai vir le CLIP dans Transform_Forward, il ne servait a rien.
 * J'ai dplac un ou deux appels par ci par la.
 * Et pis bien sur, pour clore le tout, j'utilise UPX
 *
 * Autre truc : avec VC, quand je compile avec des changement qui
 * devraient clairement changer la taille (genre une j'enleve une 
 * chaine de caractere hardcode), curieusement, ca ne change pas
 * la taille finale de l'EXE (qui, soit dit en passant, a exactement
 * la mme taille reelle que son espace occup sur le disque). J'ai
 * donc l'impression qu'il y a une cheloude histoire avec les blocs
 * d'allocation sur le disque mais j'ai pas reussi a trouver quoi.
 * UPX genere un EXE qui n'ext pas forcement egal a la taille occupe
 * sur le disque. Donc, j'imagine qu'il vire les NOP qui avaient ete
 * rajouts pour aligner la taille...
 * Si qqu'un a des ides sur ce sujet, je suis preneur
 * myself_yr@hotmail.com
 */


/*****************************************************************************
 *****************************************************************************
 *
 *                            codec_ok.c
 *
 *  compression/decompression algorithm for the SOTA'02 code compo.
 *
 *   written by Skal (skal.planet-d.net)
 *****************************************************************************
 *****************************************************************************
 *
 *  Usage:
 *
 *  * if an argument is supplied, it is supposed to be the name of the input
 *    PPM picture. The program will read this file and generate the packed
 *    file named 'a'.
 *
 *  * If no argument is supplied, the program will decompress the previous
 *    packed file ('a') into a PPM file named 'b'.
 *
 *  For short:
 *
 *    `codec pic.ppm`       => generates packed file 'a'
 *    `codec`               => decompresses 'a' into 'b'.
 *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

typedef unsigned char uint8_t;
typedef unsigned long uint32_t;

/*****************************************************************************
 * Structs and global variables
 *****************************************************************************/

#define PACK_NAME "a"
#define PIC_NAME  "b"

  /* for the sake of clarity, we use fixed dimensions */
#define WIDTH   640
#define HEIGHT  400
#define SIZE    (WIDTH*HEIGHT)

typedef struct {
  uint8_t R[SIZE], G[SIZE], B[SIZE];
} IMAGE;

static const int Offs[] = { -1, -WIDTH };

  /* Bit I/O */
static int NBits;
static uint32_t Accum;

  /* VLC */
#define MAX_CODES 512
static int Nb_Codes;
static int Order[MAX_CODES];
static int Rank[MAX_CODES];
static int Freq[MAX_CODES];

  /* Quantization */
static const int Qo     = 3;
static const int QoMask = 0xf8;

/*****************************************************************************
 * PPM utilities for I/O
 *****************************************************************************/

/* PPM format is very simple. The header is:

P6\n
640 400\n
255\n

followed by the 'R-G-B' byte triplets for each pixel, in scan order.

In the header, '640 400' are the dimensions of the picture, and '255' is
the range (8bits) for each channels.
Sometimes, there are comments (lines starting with '#') inserted
between 'P6' and the dimensions. There are not handled here...
*/

void Read_PPM(FILE *In, IMAGE *Img)
{
  int Width, Height, Format;
  int i;

  // Skip header
  for ( i=0; i<15; i++ )
    fgetc(In);
  Width = 640;
  Height = 400;
  Format = 255;
  // fscanf(In, "P6\n%d %d\n%d\n", &Width, &Height, &Format);

/*
  if (fscanf(In, "P6\n%d %d\n%d\n", &Width, &Height, &Format)!=3) {
    fprintf( stderr, "Input format doesn't seem to be raw PPM!!\n" );
    return 0;
  }
*/

/*
  if (Width!=WIDTH || Height!=HEIGHT || Format!=255) {
    fprintf( stderr, "ERROR! Either input size is not %dx%d, or format is wrong!\n",
      WIDTH, HEIGHT );
    return 0;
  }
*/

  for(i=0; i<SIZE; ++i) {
    Img->R[i] = fgetc(In);
    Img->G[i] = fgetc(In);
    Img->B[i] = fgetc(In);
  }
  // return 1;
}

void Write_PPM(const IMAGE *Img, FILE *Out)
{
  int i;

    /* PPM header */

  // replace fprintf
  char * p = "P6\n640 400\n255\n";
  while ( * p != '\0' ) fputc ( *p++, Out );
  // fprintf(Out, "P6\n640 400\n255\n");

    /* RGB data */
  for(i=0; i<SIZE; ++i) {
    fputc( Img->R[i], Out );
    fputc( Img->G[i], Out );
    fputc( Img->B[i], Out );
  }
  // return 1;
}

/*****************************************************************************
 * Bits I/O
 *****************************************************************************/

void Reset_Bits()
{
  NBits = 0;
  Accum = 0x00;
}

void Flush_Bits(FILE *Out)
{
  if (NBits>0)
    fputc( Accum>>24, Out);
/*
    if (fputc( Accum>>24, Out)==EOF) {
      fprintf( stderr, "ERROR! Unable to fputc() to file...\n" );
      exit(-1);
    }
*/
}

void Put_Bits(uint32_t v, int l, FILE *Out)
{
  NBits += l;
  Accum |= v<<(32-NBits);
  if (NBits>=8) {
  // while (NBits>=8) {
    Flush_Bits(Out);
    Accum <<= 8;
    NBits -= 8;
  }
}

uint32_t Get_Bits(int l, FILE *In)
{
  int v;
  while(NBits<l) {
    int c = fgetc(In);
/*
    if (c==EOF) {
      fprintf( stderr, "ERROR! Unexpected EOF encountered!\n" );
      exit(-1);
    }
*/
    NBits += 8;
    Accum |= c<<(32-NBits);
  }
  v = Accum >> (32-l);
  Accum <<= l;
  NBits -= l;
  return v;
}

/*****************************************************************************
 * Dynamic pseudo-Huffman
 *****************************************************************************/

void Reset_Codes()
{
  int c;

  for(c=0; c<MAX_CODES; ++c)
    Freq[c] = 0;
  Nb_Codes = 0;
}

void New_Code(uint32_t C) 
{
  Order[Nb_Codes] = C;
  Rank[C] = Nb_Codes++;
}

void Rank_Code(uint32_t C)
{
  int r;
  Freq[C]++;
  r = Rank[C];
  while(r>0 && Freq[Order[r-1]]<Freq[C])
  {
    int P = Order[r-1];
    Order[r] = P;
    Rank[P]  = r;
    r = r-1;
  }
  Order[r] = C;
  Rank[C] = r;
}

void Put_Code(uint32_t C, FILE *Out)
{
  int i;  
  if (!Freq[C]) New_Code(C);
  i = Rank[C];
  while(i>=3) {
    Put_Bits(3, 2, Out);
    i -= 3;
  }
  Put_Bits(i, 2, Out);
  if (!Freq[C]) Put_Bits(C>>Qo, 9-Qo, Out);
  Rank_Code(C);
}

uint32_t Get_Code(FILE *In)
{
  int i, C, r;

  r = 0;
  do {
    i = Get_Bits(2, In);
    r += i;
  } while (i==3);

  if (r==Nb_Codes)
    New_Code( Get_Bits(9-Qo, In) << Qo );

  C = Order[r];
  Rank_Code(C);
  return (uint32_t)C;
}

/*****************************************************************************
 * Quantization
 *****************************************************************************/

uint32_t Quantize(uint8_t *p1, uint8_t *p2)
{
  uint8_t v = ( *p1 - *p2 ) & QoMask;
  *p1 = *p2 + v;
  return (uint32_t)v;
/*
  uint8_t v = *p1 - *p2;
  v = (v>>Qo)<<Qo;
  *p1 = *p2 + v;
  return (uint32_t)v;
*/
}

/*****************************************************************************
 * Color rotation
 *****************************************************************************/

#define CLIP(x) (uint8_t)( (x)<0 ? 0 : (x)>255 ? 255 : (x) )

void Transform_Forward(IMAGE *Img)
{
  int i;
  for(i=0; i<SIZE; ++i) {
    int r, g, b, y, u, v;
    r = Img->R[i];
    g = Img->G[i];
    b = Img->B[i];
    y = ( 1*r + 2*g + 1*b ) / 4;
    u = (-1*r - 1*g + 2*b ) / 4 + 128;
    v = ( 2*r - 1*g - 1*b ) / 4 + 128;
    Img->R[i] = y;
    Img->G[i] = u;
    Img->B[i] = v;
/*
    Img->R[i] = CLIP(y);
    Img->G[i] = CLIP(u);
    Img->B[i] = CLIP(v);
*/
  }
}

void Transform_Backward(IMAGE *Img)
{
  int i;
  for(i=0; i<SIZE; ++i) {
    int r, g, b, y, u, v;
    y = Img->R[i];
    u = Img->G[i];
    v = Img->B[i];
    r = ( 3*y + 1*u + 5*v ) / 3 - 256;
    g = ( 3*y - 3*u - 3*v ) / 3 + 256;
    b = ( 3*y + 5*u + 1*v ) / 3 - 256;
    Img->R[i] = CLIP(r);
    Img->G[i] = CLIP(g);
    Img->B[i] = CLIP(b);
  }
}

#undef CLIP

/*****************************************************************************
 * Compression part
 *****************************************************************************/

void Compress_Plane(uint8_t *I, FILE *Out)
{
  int i;

  Put_Bits( *I++, 8, Out );
  for(i=1; i<WIDTH; ++i, ++I)
    Put_Code( Quantize(I, I-1), Out );
  for(i=WIDTH; i<SIZE; ++i, ++I)
    if (abs(I[0]-I[-1])>=abs(I[0]-I[-WIDTH]))
      Put_Code( 256+Quantize(I, I-WIDTH), Out );
    else Put_Code( Quantize(I, I-1), Out );
}

void Compress(IMAGE *Img, FILE *Out)
{
  // Reset_Codes(); // moved to the main()
  // Reset_Bits();

  Transform_Forward(Img);
  Compress_Plane(Img->R, Out);
  Compress_Plane(Img->G, Out);
  Compress_Plane(Img->B, Out);
  Flush_Bits(Out);

  // return 1;
}

/*****************************************************************************
 * Decompression part
 *****************************************************************************/

void Rebuild_Plane(uint8_t *I, FILE *In)
{
  int i;
  *I++ = (uint8_t)Get_Bits(8, In);
  for(i=1; i<SIZE; ++i, ++I) {
    const uint32_t c = Get_Code(In);
    *I = I[Offs[c>>8]] + (uint8_t)(c&0xff);
  }
}

void Decompress(FILE *In, IMAGE *Img)
{
  // Reset_Codes(); // moved to the main()
  // Reset_Bits();

  Rebuild_Plane(Img->R, In);
  Rebuild_Plane(Img->G, In);
  Rebuild_Plane(Img->B, In);
  Transform_Backward(Img);
//  return 1;
}

/*****************************************************************************
 * main call
 *****************************************************************************/

void main(int argc, const char *argv[])
{
/*
  FILE * fic = fopen (argv[1], "rb");
  int n=0;
  int a=0;
  while ( !feof ( fic ) ) 
   {
    a = fgetc ( fic );
    n++;
   }
  // fseek ( fic, SEEK_END, 0 );
  // printf ( "Taille : %i octets\n", ftell(fic));   
  printf ( "Taille : %i octets [%i]\n", n-1, a );   
  return 0;
*/
  IMAGE Img;
  FILE *Out, *In;

  Reset_Codes();
  Reset_Bits();

  if (argc>1)           /* compress */
  {
    Out = fopen( PACK_NAME, "wb" );
    In  = fopen( argv[1], "rb" );
    // if (Out==0 || In==0) goto IO_Error;

    Read_PPM(In, &Img);
	Compress(&Img, Out);
/*
    if ( !Read_PPM(In, &Img) || !Compress(&Img, Out) )
      fprintf( stderr, "Error during compression.\n" );
*/
  }
  else                  /* decompress */
  {
    In = fopen( PACK_NAME, "rb" );
    Out = fopen( PIC_NAME, "wb" );

    // if (Out==0 || In==0) goto IO_Error;

    Decompress(In, &Img);
	Write_PPM(&Img, Out);
/*
    if ( !Decompress(In, &Img) || !Write_PPM(&Img, Out) )
      fprintf( stderr, "Error during decompression.\n" );
*/
  }

  // fclose(In);
  // fclose(Out);

  // return 0;
}

/*****************************************************************************/
// Seul truc qui rend le fichier invalide pour l'instant :
// resolution/format