


b	equ	byte ptr
w	equ	word ptr
d	equ	dword ptr

.MODEL SMALL
.CODE
.586
assume	cs:@code,ds:@code,es:@code, ss:@code


TailleHeader = offset HeaderEnd - Header


org	100h
debut:
	push	cs
	pop	ds
	push	cs
	pop	es

; resetCodes + resetbits
;	mov	di, offset Freq
;	xor	ax, ax		; ax = 0 au debut d'un .com
	mov	ch, 7
	mov	di, cx		; un octet de gagne :)
	rep	stosw		; on est sur de mettre a 0 tout ce qui doit l'etre

	mov	di, offset HandleIn
	mov	cl, 2
looploadfics:
	mov	ah, 3Bh
	add	ah, cl
	mov	dx, di
	dec	cx
	int	21h		; 3Ch et 3Dh ne touchent pas a cx
	inc	cx
	stosw
	loop	looploadfics


; Ecriture du header dans le fichier image

	xchg	bx, ax
	mov	ah, 40h
	mov	dx, di		; offset header
	mov	cl, TailleHeader
	push	cx
	int	21h

	pop	dx	; mov dx, TailleHeader
	mov	cl, 3
	mov	ax, 4200h
RebuildPlanesLoop:
	pusha
	xor	cx, cx
	int	21h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

RebuildPlane:	; bx=handle fichier image, bp = handle fichier In
; cx = offset dans le fichier image par rapport au premier R

	mov	bp, 8		; 8 bits a lire
	call	GetBits		; al = bits lus

	; ecrit dans le fichier image a l'endroit courant l'octet lu
	call	EcritOctetDansImage

	mov	ecx, (640*400) - 1
RebuildLoop:
	pusha

	mov	ah, 19h		; fonction du dos ne servant a rien
	mov	cx, 2		; decalage pour le prochain pixel
	call	DeplaceDansImageEtLitOuEcritOctet

;GetCode:	; bx = handle du fichier d'entree

	cwd		; xor dx, dx
	mov	bp, 2

GetCode_DoWhile:
	push	dx
	push	bp
	call	GetBits		; ax = i = GetBits( 2, In)
	pop	bp
	pop	dx

	add	dx, ax		; r += i
	cmp	al, 3
	je	GetCode_DoWhile	; while(i==3)
	
	cmp	dx, [NbCodes]
	push	dx
	jne	pasnewcode

	mov	bp, 6
	call	GetBits
	cbw			; ax = GetBits(6, In)
	imul	bx, ax, 8	; bx = GetBits(6, In) << 3

;newcode:
	mov	ax, [NbCodes]
	imul	di, ax, 2	; di = nbcodes * 2
	mov	Order[di], bx	; Order[nb_codes ] =C

	mov	Rank[bx], al	; rank[C] = nbcodes
	inc	[NbCodes]	; NbCodes++

pasnewcode:
	pop	bx		; bx = r
	add	bx, bx
	mov	bp, Order[bx]	; bp = C = Order[r]

RankCode:	; bp = C
; Detruit : eax, bx, cx, edx, si, di
; retour dans bp = C

	movzx	cx,b Rank[bp]	; cx = Rank[C]

	imul	bx, bp, 4	; bx = 4*C
	inc	Freq[bx]	; Freq[C]++;

loopUpdate:
	jcxz	AfterloopUpdate	; r == 0 

	imul	si, cx, 2	; si = 2*r

	mov	bx, Order[si-2] ; dx = Order[r-1]
	imul	di, bx, 4	; di = 4*Order[r-1]
	mov	eax, Freq[di]	; eax = Freq[Order[r-1]]

	imul	di, bp, 4
	cmp	eax, Freq[di]	
	jnb	AfterloopUpdate	; condition d'arret du while

	mov	Order[si], bx	; Order[r] = P
	mov	Rank[bx], cl	; Rank[P] = r

	loop	loopUpdate
AfterloopUpdate:
	imul	di, cx, 2
	mov	Order[di], bp	; Order[r] = C
	mov	Rank[bp], cl	; Rank[C] = r


;	call	GetCode
	mov	cx, -3
	cmp	bp, 100h
	jb	no_modifcx
	mov	cx, - 640*3
no_modifcx:
	mov	ah, 3Fh		; on lit l'octet reference
	push	bp
	push	cx
	call	DeplaceDansImageEtLitOuEcritOctet
	pop	cx
	pop	bp		; bp = c

	not	cx		; = neg cx , dec cx
				; on doit se deplacer dans l'autre sens
				; (on avait avance d'un cran a la lecture)
	add	ax, bp		; al = I[Offs[c>>8]] + uint8(c)
	call	DeplaceDansImageEtEcritOctet
	popa

	dec	ecx
	jnz	RebuildLoop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



	popa
	inc	dx
	dec	cx
	jnz	RebuildPlanesLoop

;	mov	ax, 4200h		; ax deja = 4200
	mov	dl, TailleHeader	; dh = 0, cx = 0
	int	21h


TransformBackward:
LoopTransform:

	mov	dx, 3
LoopLoad:
	mov	ah, 3Fh
	push	dx
	xor	cx, cx
	call	DeplaceDansImageEtLitOuEcritOctet
	pop	dx
	push	ax
	dec	dx
	jnz	LoopLoad	

	pop	cx	; cx = v
	pop	bx	; bx = u
	pop	di	; di = y

	jc	Fin

	mov	ax, di	; calcul du g
	sub	ax, bx
	sub	ax, cx
	inc	ah
	call	clampAx

	push	ax		; sauvegarde g
	
	imul	di, di, 3	; di = y*3

	call	ComputeRouB	; ax = r
	pusha
	mov	cx, -3
	call	DeplaceDansImageEtEcritOctet
	popa

	pop	ax		; ax = g
	pusha
	call	EcritOctetDansImage
	popa

	xchg	bx, cx		; pour que le calcul donne ax = b
	call	ComputeRouB

	call	EcritOctetDansImage

	jmp	LoopTransform



ComputeRouB:
	mov	bp, 3
	imul	ax, cx, 5	; ax = 5*cx
	add	ax, bx		; ax = 5*cx + bx
	add	ax, di		; ax = 5*cx + bx + 3*y
	cwd
	idiv	bp		; ax = (5*cx + bx + 3*y)/3
	dec	ah		; ax = (5*cx + bx + 3*y)/3 - 256

clampAx:
	cmp	ah, 0
	jng	OKClamp1
	mov	al, 255
OKClamp1:
	test	ax, ax
	jns	OKClamp2
	xor	ax, ax
OKClamp2:
Fin:
	ret



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
GetBits:
; bx : handle du fichier	
; bp : nb de bits a lire ( < 8)

; resultat dans ax
; Detruit : cx, dx, bp
	mov	bx, [HandleIn]

	xor	ax, ax
	movzx	cx, [nbbitsaccum]

	cmp	bp, cx		; si il y a suffisamment de bits dans l'accum
	jb	litBpBits	; alors on va les chercher OK

	sub	bp, cx		; il faudra lire ensuite demande - dispo
	push	bp

	mov	bp, cx		; on recupere ce qu'il ya de dispo
	call	litBpBits

	push	ax
	mov	ah, 3Fh		; puis on lit 1 octet
	mov	cx, 1
	mov	dx, offset accum
	int	21h
	pop	ax

	mov	[nbbitsaccum], 8

	pop	bp		; et on lit le reste

litBpBits:
	mov	cx, bp		; et on lit les 
	mov	dh, [accum]
	shld	ax, dx, cl	; lit les bits dispo
	shl	dx, cl
	mov	[accum], dh
	sub	[nbbitsaccum], cl
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


EcritOctetDansImage:
	xor	cx, cx
DeplaceDansImageEtEcritOctet:
	mov	ah, 40h
DeplaceDansImageEtLitOuEcritOctet:
	push	ax

	mov	si, offset dummy
	mov	[si], al
	mov	bx, [HandleImg]
	xchg	cx, ax	; ax = taille
	cwd		; dx = extension bits taille
	xchg	ax, dx	; dx = taille, ax = extension
	xchg	cx, ax	; cx = extension
	mov	ax, 4201h
	int	21h	; deplacement relatif fait

	pop	ax	; ah = 3Fh pour lecture, 40h pour ecriture

	mov	cx, 1 
	mov	dx, si
	int	21h
	cmp	al, 1	; si eof (cas du 3Fh), cf = 1
	lodsb
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

HandleIn	LABEL WORD
file	db	"a",0
HandleImg	LABEL WORD
file2	db	"b",0
Header	db	"P6",0Ah,"640 400", 0Ah, "255", 0Ah
HeaderEnd:
dummy	db	?

Order	dw	512 dup (?)
Rank	db	512 dup (?)

ORG	800h

Freq	dd	512 dup (?)	; a partir d'ici : mis a 0
NbCodes	dw	?
nbbitsaccum	db	?
accum		db	?


end	debut
