{$mode delphi}
unit efx7;

interface

uses windows,gl;

function efx7_init_new (note, volume: word): boolean;
procedure efx7_draw;

implementation

const 
	max = 8;
	tt = 350;

var 
	p: array [0..max-1] of record
		playing: boolean;
		startTime: dword;
		x,y: glfloat;
		dx,dy: glfloat;
		r,g,b,a: glfloat;
	end;
	
function efx7_init_new (note, volume: word): boolean;
var 
	i,j: integer;
begin
	j:=-1;
	for i:=0 to max-1 do if not p[i].playing then j:=i;
	if j=-1 then begin
		result:=false;
		exit;
	end;
	with p[j] do begin
		playing:=true;
		startTime:=getTickCount;
		x:=random;
		y:=random;
		r:=random; g:=random; b:=random; a:=(volume/64)+0.3;
		
    	dx:=cos(r*2*pi);
    	dy:=sin(r*2*pi);
    	
		if a>1.0 then a:=1.0;
	end;
end;
	
procedure efx7_draw;
var t: longint;
	i: integer;
begin
	for i:=0 to max-1 do with p[i] do if playing then begin
		t:=getTickCount-startTime;
		if t>tt then playing:=false;
		glColor4f(r,g,b,a-(t/tt)*a);
		glPushMatrix();
		glTranslatef(x+dx*(t/tt)*0.1,y+dy*(t/tt)*0.1,0);
		glRotatef(r*360-90,0,0,1);
		glScalef(0.1,0.1,1);
		glBegin(GL_TRIANGLES);
		glVertex2f(-2,0); glVertex2f(0,2); glVertex2f(-1,0);
		glVertex2f(-1,0); glVertex2f(0,2); glVertex2f(1,0);
		glVertex2f(0,2); glVertex2f(2,0); glVertex2f(1,0);		
		glEnd();
		glBegin(GL_QUADS);
		glVertex2f(-1,0); glVertex2f(1,0);
		glVertex2f(1,-3); glVertex2f(-1,-3);
		glEnd();
		glPopMatrix();
	end;
end;

var i: integer;

begin
	for i:=0 to max-1 do p[i].playing:=false;
end.