#ifndef EFFETS_DEJA_INCLUS
#define EFFETS_DEJA_INCLUS

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : ZoomOver()                                                    |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Zoom/deZoom une image source dans une image destination    |
    |                en fonction du facteur de Zoom                             |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Images, StructImage_t *p_pt_Ecran,      |
    |               unsigned short l_c_Pas                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Un pointeur sur la structure StructEcran                |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void ZoomOver( StructImage_t *p_pt_Images, StructImage_t *p_pt_Ecran, char l_c_Pas );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : FadeOut()                                                     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Reduit le Nb de couleur jusqu'au noir total                |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Images, int Pas                         |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : OK si fader fini NON sinon                              |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
void FadeOut( StructImage_t *p_pt_Image, float p_f_Pas );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : Ecoule()                                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Ecoule l'ecran en faisant apparaitre le suivant            |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Ecran1,StructImage_t *p_pt_Ecran2,      |
    |               unsigned char p_uc_Pas                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void Ecoule( StructImage_t *p_pt_Ecran1, StructImage_t *p_pt_Ecran2, unsigned char p_uc_Pas );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : InitScrollTexteSurRelief()                                    |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Recupre toutes les ordonnes du relief                    |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Relief, unsigned short *p_pus_NbElements|
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : pointeur sur le tableau des ordonnes                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
unsigned short *InitScrollTexteSurRelief( StructImage_t *p_pt_Relief );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : ScrollTexteSurRelief()                                        |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Fait scroller un sprite sur un relief de droite a gauche   |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Image, StructImage_t *p_pt_Image,       |
    |               StructImage_t *p_pt_Relief, unsigned char p_uc_Pas          |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void ScrollTexteSurRelief( StructImage_t *p_pt_Sprite, StructImage_t *p_pt_Image, StructImage_t *p_pt_Relief, unsigned char p_uc_Pas );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : MoveTo()                                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Deplace un sprite avec clipping                            |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Sprite, StructEcran_t *p_pt_Ecran,      |
    |               short p_s_DebutX, short p_s_DebutY, short p_s_FinX,         |
    |               short p_s_FinY, unsigned char p_uc_Pas                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void MoveTo( StructImage_t *p_pt_Sprite, StructImage_t *p_pt_Ecran, short p_s_DebutX, short p_s_DebutY, short p_s_FinX, short p_s_FinY, unsigned char p_uc_Pas );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : Flash()                                                       |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Affiche plusieurs flash a une certaine frequence           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Destination, unsigned char p_uc_NbFlash,|
    |               unsigned char p_uc_Frequence, unsigned char p_uc_Rouge,     |
    |               unsigned char p_uc_Vert, unsigned char p_uc_Bleu            |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
void Flash( StructImage_t *p_pt_Destination, unsigned char p_uc_NbFlash, unsigned short p_us_Frequence, unsigned char p_uc_Rouge, unsigned char p_uc_Vert, unsigned char p_uc_Bleu );


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : Zoom()                                                        |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Zoom/deZoom une image source dans une image destination    |
    |                en fonction du facteur de Zoom                             |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Image                                   |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Un pointeur sur la structure StructEcran                |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

int Zoom( StructImage_t *p_pt_Image );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : WarpApparence()                                               |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Apparition/Disparition en 'Warp' d'une image               |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Warp, StructImage_t *p_pt_Ecran,        |
    |               StructImage_t *p_pt_ImgSuivante, unsigned char p_uc_Pas     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void WarpApparence( StructImage_t *p_pt_Warp, StructImage_t *p_pt_Ecran, StructImage_t *p_pt_ImgSuivante, unsigned char p_uc_Pas );


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : MoveToH()                                                     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Deplace un sprite avec clipping dans une direction         |
    |                horozontale                                                |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Sprite, StructEcran_t *p_pt_Ecran,      |
    |               short p_s_DebutX, p_s_FinX, short p_s_PositionY,            |
    |               unsigned char p_uc_Pas                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void MoveToH( StructImage_t *p_pt_Sprite, StructImage_t *p_pt_Ecran, short p_s_DebutX, short p_s_FinX, short p_s_PositionY, unsigned char p_uc_Pas );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : MoveToV()                                                     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Deplace un sprite avec clipping dans une direction         |
    |                Verticale                                                  |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Sprite, StructEcran_t *p_pt_Ecran,      |
    |               short p_s_DebutY, p_s_FinY, short p_s_PositionX,            |
    |               unsigned char p_uc_Pas                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void MoveToV( StructImage_t *p_pt_Sprite, StructImage_t *p_pt_Ecran, short p_s_DebutY, short p_s_FinY, short p_s_PositionX, unsigned char p_uc_Pas );


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : VideoApparence()                                              |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Transforme une image en effet d'image de tl              |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Ecran                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void VideoApparence( StructImage_t *p_pt_Ecran );


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : LigneElectrique()                                             |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Trace une ligne electrique                                 |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Ecran, short p_s_DebutX,                |
    |               short p_s_DebutY, short p_s_FinX, short p_s_FinY            |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
void LigneElectrique( StructImage_t *p_pt_Sprite, StructImage_t *p_pt_Ecran, short p_s_DebutX, short p_s_DebutY, short p_s_FinX, short p_s_FinY );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : AfficheBulle()                                                |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Affiche une Bulle sur un fond                              |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : unsigned short p_us_PosX, unsigned short p_us_PosY,         |
	|               StructImage_t *p_pt_Bulle, StructImage_t *p_pt_Fond         |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void AfficheBulle( short p_s_PosX, short p_s_PosY, StructImage_t *p_pt_Bulle, StructImage_t *p_pt_Fond );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : NeigeTV()                                                     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Affiche de la neige dans un buffer                         |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : SDL_Surface *p_p_Buffer, SDL_Rect p_sdl_Coords              |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
void NeigeTV( SDL_Surface *p_p_Buffer, SDL_Rect p_sdl_Coords );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : Flou()                                                        |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Smooth un buffer                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructImage_t *p_pt_Buffer, unsigned short p_us_DebutX,     |
		|               unsigned short p_us_DebutY, unsigned short p_us_Largeur,    |
		|               unsigned short p_us_Hauteur, unsigned char p_uc_PasFlou     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : OK si le flou est fini, NOK sinon                       |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

int  Flou( StructImage_t *p_pt_Buffer, unsigned short p_us_DebutX, unsigned short p_us_DebutY, unsigned short p_us_Largeur, unsigned short p_us_Hauteur, unsigned char p_uc_PasFlou );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : PrepareGeneriqueStarWars()                                    |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Prepare un tableau  pour y stocker les coordonnees X et Y  |
    |                de la pente                                                |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :   short *p_ps_Perspective, short p_s_DebutX,                |
    |                 short p_s_DebutY, short p_s_FinX, short p_s_FinY          |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
void PrepareGeneriqueStarWars( short *p_ps_Perspective, short p_s_DebutX, short p_s_DebutY, short p_s_FinX, short p_s_FinY );

#endif
