#ifndef OUTILS_DEJA_INCLUS
#define OUTILS_DEJA_INCLUS

#include <stdlib.h>
#include <math.h>
#include <windows.h>

#include "SDL_mixer.h"
#include "SDL.h"
#include "Main.h"
#include "SDL_image.h"

#define PATH_IMAGES "Datas\\Images\\"
#define PATH_ZICS   "Datas\\Sons\\"

#define FREQUENCE 44100
#define CANNAUX   2 /* -- stereo -- */
#define BUFFER_DONNEES 4096 /* -- Buffer temporaire de lecture -- */
#define AUDIO_FORMAT AUDIO_S16 /* -- 16 Bits -- */

/*#define BOOL  unsigned char
#define TRUE  0
#define FALSE 1*/

#define NOK 1
#define OK  0

#define DEBUG 0


/* -- Structure Ecran -- */
typedef struct
{
  unsigned short Largeur;
  unsigned short Hauteur;
  unsigned char  Bpp;
  
  SDL_Surface *DonneesImage;
  SDL_Rect Coords;

}StructEcran_t;

/* -- Structure Image -- */
typedef struct
{
  unsigned short Largeur;
  unsigned short Hauteur;
  unsigned char  Bpp;
  
  SDL_Surface *DonneesImage;
  SDL_Rect Coords;
}StructImage_t;

/* -- Structure audio -- */
typedef struct
{
  int Frequence;     /* -- 11025(l c'est vraiment pourrit), 22050, 44100 -- */
  int Cannaux;       /* -- Mono ou Stereo -- */
  int BufferDonnees; /* -- 4096 est un bon choix pour le buffer temporaire de lecture -- */
  int Boucle ;       /* -- TRUE ou FALSE -- */
  unsigned short FormatAudio; /* -- 8Bits ( AUDIO_U8 )ou 16 Bits ( AUDIO_S16 ) -- */

  
  Mix_Music *DonneesAudio;
}StructAudio_t;

/* -- Variables Globales pour les outils -- */

//BOOL GLOBAL_FlagOuvrirAudio;
//unsigned short GLOBAL_NbAllocationZics, GLOBAL_NbAllocationImages;
//unsigned short GLOBAL_FixeFPS;
/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : OpenScreen()                                                  |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Initialise le mode video                                   |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : unsigned short Larg, unsigned short Haut, unsigned char Bpp,|
    |               FullScreen                                                  |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Un pointeur sur le buffer Video                         |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

StructEcran_t *OpenScreen( unsigned short p_us_Larg, unsigned short p_us_Haut, unsigned char p_uc_Bpp, short p_s_FullScreen );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : CloseScreen()                                                 |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Ferme le mode video et libere la memoire                   |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : le buffer video alloue                                      |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
void CloseScreen( StructEcran_t *p_p_Ecran );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : OpenAudio()                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Initialise le canal audio                                  |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : Aucun                                                       |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Le pointeur sur la structure StructAudio_t              |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

StructAudio_t *OpenAudio();

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : CloseAudio()                                                  |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Ferme le canal audio                                       |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : Aucun                                                       |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void CloseAudio( StructAudio_t * p_pt_Audio);

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : CloseZic()                                                    |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : libere la memoire allouee                                  |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : La structure Audio                                          |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void CloseZic( StructAudio_t *p_p_Audio );


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : LoadZic()                                                     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Charge le fichier de zic                                   |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructAudio_t *, char *NomZic                               |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : OK si OK et NOK si non OK                               |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

StructAudio_t *LoadZic( StructAudio_t *p_pt_Audio, char * p_pc_NomZic );


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : LoadImage()                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Charge l'image en mmoire la convertie dans la reso        |
    |                utilise                                                   |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : char *p_pc_ImageSource, int  p_i_FlagAlpha,                 |
    |               unsigned char p_uc_Rouge, unsigned char p_uc_Vert,          |
    |               unsigned char p_uc_Bleu                                     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : StructImage_t * si OK NULL si non                       |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

StructImage_t *O_LoadImage( char *p_pc_ImageSource, BOOL p_b_FlagAlpha, unsigned char p_uc_Rouge, unsigned char p_uc_Vert, unsigned char p_uc_Bleu );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : LoadAudio()                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Charge le fichier de zic                                   |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES : StructAudio_t *, char *NomZic                               |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : OK si OK et NOK si non OK                               |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
void LoadAudio( StructAudio_t *p_pt_Audio, char * p_pc_NomZic );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : PlayAudio()                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Lance la zic en tache de fond                              |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  StructAudio_t *                                            |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void PlayAudio( StructAudio_t *p_pt_Zic );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : CloseImage()                                                  |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Libere la memoire allouee pour les images                  |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  StructImage_t *                                            |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
void CloseImage( StructImage_t *p_pt_Image );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : PutPixelRVB()                                                 |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Pose un pixel a l'endroit renseign dans les arguments     |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  StructImage_t *, int PosX, int PosY, char R, char V, char B|
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void PutPixelRVB( StructImage_t *p_pt_Buffer, unsigned short l_us_PositionX, unsigned short l_us_PositionY, unsigned char p_uc_Rouge, unsigned char p_ucVert, unsigned char p_uc_Bleu );


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : PutPixel                                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Pose un pixel a l'endroit renseign dans les arguments     |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  StructImage_t *, int PosX, int PosY, char R, char V, char B|
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void PutPixel( StructImage_t *p_pt_Buffer, unsigned short l_us_PositionX, unsigned short l_us_PositionY, unsigned long p_ul_CouleurPixel );


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : GetPixel                                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Recupre la couleur d'un pixel a l'endroit renseign       |
    |                dans les arguments                                         |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  StructImage_t *, int PosX, int PosY, char R, char V, char B|
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

unsigned short O_GetPixel( StructImage_t *p_pt_Buffer, unsigned short l_us_PositionX, unsigned short l_us_PositionY );


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : PutSprite()                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Copie un sprite dans un buffer destination                 |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  StructImage_t *Src, StructImage_t *Dest, int PosX,int PosY |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void PutSprite( StructImage_t *p_pt_Sprite, StructImage_t *p_pt_BufferDestination,  short p_us_PosX,  short p_us_PosY );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : WaitKey()                                                     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Test et renvoie l'etat de la touche passe en parametre     |
    |                ne gere que la touche "escape"                             |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  unsigned short p_us_Key                                    |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : TRUE si la touche est pressee FALSE sinon               |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

BOOL WaitKey();


/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : WaitDelayAndWaitKey()                                         |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Attends X millisecondes en Testant l'appui de la touche    |
    |                ne gere que la touche "escape"                             |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  unsigned short p_us_Delay (pas plus de 60 secondes)        |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void WaitDelayAndWaitKey( unsigned short p_us_Delay );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : Affiche()                                                     |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Affiche le buffer passe en parametre. Il est possible de   |
    |                limiter le nombre de frames/seconde grace a la varible     |
    |                globale suivante : GLOBAL_FixeFPS ( 60 fps seble correcte) |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  StructImage_t *p_pt_Image                                  |
    |                                                                           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void Affiche( StructImage_t *p_pt_Image );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : InitVariableGlobales()                                        |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Initialise toutes les variables globales                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  Aucun                                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/

void InitVariablesGlobales();

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : MappeLigneH()                                                 |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Mappe une ligne quelconque en une ligne horizontale        |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  Aucun                                                      |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : Aucun                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
void MappeLigneH( long x1, long y1, long x2,long y2, StructImage_t *p_pt_Source, long x3, long y3, long L, StructImage_t *p_pt_Destination );

/*
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  FONCTION : SoundSync()                                                   |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  DESCRIPTION : Incrmente une variable globale premtant la syncro sound  |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  PARAMETRES :  unsigned long p_ul_Intervale, void *p_void_Param           |
    |                                                                           |
    +---------------------------------------------------------------------------+
    |                                                                           |
    |  CODE DE RETOUR : p_ul_Intervale                                          |
    |                                                                           |
    +---------------------------------------------------------------------------+
*/
unsigned long SoundSync( unsigned long p_ul_Intervale, void *p_void_Param );

#endif
