/*
 * Yes, this is ugly, but the decision to use blobs in the demo came
 * way too late to make it any prettier ;-)
 */

#include <math.h>
#include "blobhandler.h"

#define DEBUG_AREA 0

BlobHandler::BlobHandler(MainLoop *ml, const char *title, const char *elem, Hashtable *attr) :
	Event(ml, title, elem, attr, "alpha:x:y:z:xrot:yrot:zrot:scale")
{
	this->tex = texture::load(attr->get_str("texture"));
	this->mb = new Blob(4);
}

BlobHandler::~BlobHandler()
{
	texture::free(this->tex);
	delete this->mb;

	this->tex = NULL;
	this->mb = NULL;
}

void BlobHandler::start_effect()
{
}

void BlobHandler::draw_scene(float progress)
{
	float alpha = this->get_val("alpha", progress);

	GLfloat material[] = { 1.0f, 1.0f, 1.0f, alpha };
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, material);

	const float p = progress * 3.0f + 0.8f;
	
	const float scale = this->get_val("scale", progress);
	glScalef(scale, scale, scale);
	
	/* camera */
	float xpos = this->get_val("x", progress);
	float ypos = this->get_val("y", progress);
	float zpos = this->get_val("z", progress);
	glTranslatef(xpos, ypos, zpos);

	float xrot = this->get_val("xrot", progress);
	float yrot = this->get_val("yrot", progress);
	float zrot = this->get_val("zrot", progress);
	glRotatef(xrot, 1.0f, 0.0f, 0.0f);
	glRotatef(yrot, 0.0f, 1.0f, 0.0f);
	glRotatef(zrot, 0.0f, 0.0f, 1.0f);

	mb->set_moving_point(0,
		45.0 * cos(4 + p * 1.24 * 5),
		37.5 * sin(2.0 - p * 0.41 * 5),
		37.5 * cos(1.0 - p * 1.2 * 5),
                       1300.0);
	mb->set_moving_point(1,
		37.5 * sin(20 - p * 1.14 * 5),
		52.5 * cos(1.5 + p * 0.71 * 5),
		45.0 * cos(5.0 + p * 1.12 * 5),
                       1300.0);
	mb->set_moving_point(2,
		45.0 * cos(76.0 + p * 0.94 * 5),
		45.0 * cos(-p * 1.01 * 5),
		37.5 * sin(8.0 - p * 1.62 * 5),
                       1300.0);
	mb->set_moving_point(3,
		52.5 * sin(1.0 - p * 1.31 * 5),
		30.0 * cos(p * 1.41 * 5),
		37.5 * cos(3.0 + p * 1.42 * 5),
                       800.0);

	tex->bind();
	glDisable(GL_CULL_FACE);
        glEnable(GL_DEPTH_TEST);
	glDisable(GL_NORMALIZE);
        glEnable(GL_TEXTURE_2D);
        glEnable(GL_LIGHTING);
       	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);

	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);

	glEnable(GL_COLOR_MATERIAL);
	glColor4f(1.0f, 1.0f, 1.0f, alpha);	
	mb->draw_object();

	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);

	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);

#if DEBUG_AREA
	/*
	 * draw the metaball area so we can fit it optimally
	 * at compile/design time
	 */
	glLineWidth(3.0f);
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_CULL_FACE);

	for (int i = 0; i < 2; i++) {
		GLenum prim;
		if (i == 0) {
			glColor4f(1.0f, 1.0f, 1.0f, 0.8f);
			prim = GL_LINE_LOOP;
		} else {
			glColor4f(1.0f, 1.0f, 1.0f, 0.3f);
			prim = GL_QUADS;
		}
	
		glBegin(prim);
		glVertex3f(GP_MINX, GP_MINY, GP_MINZ);
		glVertex3f(GP_MAXX, GP_MINY, GP_MINZ);
		glVertex3f(GP_MAXX, GP_MAXY, GP_MINZ);
		glVertex3f(GP_MINX, GP_MAXY, GP_MINZ);
		glEnd();
	
		glBegin(prim);
		glVertex3f(GP_MINX, GP_MINY, GP_MAXZ);
		glVertex3f(GP_MAXX, GP_MINY, GP_MAXZ);
		glVertex3f(GP_MAXX, GP_MAXY, GP_MAXZ);
		glVertex3f(GP_MINX, GP_MAXY, GP_MAXZ);
		glEnd();
	
		glBegin(prim);
		glVertex3f(GP_MINX, GP_MINY, GP_MINZ);
		glVertex3f(GP_MINX, GP_MINY, GP_MAXZ);
		glVertex3f(GP_MINX, GP_MAXY, GP_MAXZ);
		glVertex3f(GP_MINX, GP_MAXY, GP_MINZ);
		glEnd();
	
		glBegin(prim);
		glVertex3f(GP_MAXX, GP_MINY, GP_MINZ);
		glVertex3f(GP_MAXX, GP_MINY, GP_MAXZ);
		glVertex3f(GP_MAXX, GP_MAXY, GP_MAXZ);
		glVertex3f(GP_MAXX, GP_MAXY, GP_MINZ);
		glEnd();
	
		glBegin(prim);
		glVertex3f(GP_MINX, GP_MINY, GP_MINZ);
		glVertex3f(GP_MINX, GP_MINY, GP_MAXZ);
		glVertex3f(GP_MAXX, GP_MINY, GP_MAXZ);
		glVertex3f(GP_MAXX, GP_MINY, GP_MINZ);
		glEnd();
	
		glBegin(prim);
		glVertex3f(GP_MINX, GP_MAXY, GP_MINZ);
		glVertex3f(GP_MINX, GP_MAXY, GP_MAXZ);
		glVertex3f(GP_MAXX, GP_MAXY, GP_MAXZ);
		glVertex3f(GP_MAXX, GP_MAXY, GP_MINZ);
		glEnd();
	}
	
	glLineWidth(1.0f);
#endif
}

void BlobHandler::end_effect()
{
}
