#include <stdio.h>
#include <math.h>

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

#include "math/vector.h"
#include "exception.h"
#include "uplaneshandler.h"
#include "demolib_prefs.h"

#if DEMOLIB_MAINLOOP

UPlanesHandler::UPlanesHandler(MainLoop *ml, const char *title, const char *elem, Hashtable *attr) :
	ObjHandler(ml, title, elem, attr)
{
	this->xnum = attr->get_int("xnum");
	if (this->xnum <= 0)
		throw new FatalException(elem, "xnum= must be a positive integer!");
	
	this->ynum = attr->get_int("ynum");
	if (this->ynum <= 0)
		throw new FatalException(elem, "ynum= must be a positive integer!");
	
	this->znum = attr->get_int("znum");
	if (this->znum <= 0)
		throw new FatalException(elem, "znum= must be a positive integer!");

	this->xspace = attr->get_float("xspace");
	this->yspace = attr->get_float("yspace");
	this->zspace = attr->get_float("zspace");
	
	this->xstrength = attr->get_float("xstrength");
	this->ystrength = attr->get_float("ystrength");
	this->zstrength = attr->get_float("zstrength");
	
	this->no_zbuffer = true;
}

UPlanesHandler::~UPlanesHandler()
{
}

void UPlanesHandler::start_effect()
{
	Object::start_effect();
}

void UPlanesHandler::draw_scene(float progress)
{
	float xfreq = this->get_val("user1", progress);
	float yfreq = this->get_val("user2", progress);
	float zfreq = this->get_val("user3", progress);
	float prog  = this->get_val("user4", progress);

	this->setup_drawing(progress);
	
	for (int i = 0; i < this->xnum; i++) {
		int ci = i - xnum/2;
		const float x = (xspace + sin((float)ci * xfreq + prog) * xstrength) * ci;
		for (int j = 0; j < this->ynum; j++) {
			int cj = j - ynum/2;
			const float y = (yspace + sin((float)cj * yfreq + prog) * ystrength) * cj;
			for (int k = 0; k < this->znum; k++) {
				int ck = k - znum/2;
				const float z = (zspace + sin((float)ck * zfreq + prog) * zstrength) * ck;
				
				glMatrixMode(GL_MODELVIEW);
				glPushMatrix();
				glTranslatef(x, y, z);
			
				Object::draw_object();

				glPopMatrix();
			}
		}
	}
}

void UPlanesHandler::end_effect()
{
	Object::end_effect();
}

#endif
