;   Conway's Game of Life 
;      for the 4EvEr03
;    128 byte intro compo
;
; code:  bubis/Resource
; email: bubis@resource.cx

.org	$2000-2
.word	$2000

screen0 = $4000
screen1 = $5000

.zeropage
p0 = $2d
p1 = $2f
resc = $06
block = $07
.code

	; screen init
	ldy #0
c1:	lda #$a0
sh = *+2
	sta $4000,y
	iny
	bne c1
	inc sh
	bpl c1

	sty $ff19

restart:

	;(re)starting pattern
	lda #$01
	ldx #4
c2:	ldy patt,x
	sta screen0+459,y
	dex
	bpl c2

	lda #$40
	sta resc

	lda #>screen1
	bne ju
	
step:
	lda $ff14
	and #$f8
ju:	sta p1+1
	eor #((>screen0) ^ (>screen1))
	sta p0+1
	sta $ff14

	lda #3
	sta block
	
cyc:
	;counting the neighbours
	lda #0
	ldx #7
c:	ldy ntab,x
	clc
	adc (p0),y
	sta $ff11	;sound fx, hehe
	dex
	bpl c
	and #15
	tax
	ldy #41
	lda (p0),y
	cpx #2		; survival
	beq w

	lda $ff00	;"random" color
	and #$70
	ora #$41
	cpx #3		; birth
	beq w
	lda #0		; death
w:	sta (p1),y

	inc p0
	inc p1
	bne cyc
	inc p0+1
	inc p1+1
	dec block
	bne cyc

	dec resc
	bne step
	beq restart

; (Re)starting pattern (5 byte!)
; Pattern name: R-pentomino
;
;   XX
;  XX
;   X
;

patt:	.byte 41

; The neighbours
;
;  XXX
;  X X
;  XXX
;

ntab:	.byte 1,2,40,81,0,42,80,82

