	
	ORG $1100-2
	DW $1100
	
count		= $D0
hi_count	= $D1
snare_cnt	= $D2
channel_cnt	= $D3
	
	;DW $100B,0
	;DB $9E,"4361",0,0,0
	;ORG $1100
	
hi_frq  
	;
	; arpeggio chords
	;
	; 4 chords arranged in groups of three
	; each chord's last note is the next ones first
	;
	DB 939 & 255,881 & 255	; E G
	DB 911 & 255		; B
	DB 872 & 255,929 & 255	; F# D
	DB 872 & 255,897 & 255	; F# A
	DB 917 & 255,854 & 255	; C E
	;
	LDY #$FF	; y is note (+other things) counter
	;
main	LDA #$C7
	STA $FF12	; set chords high byte (+ sync to frame)
sync	CMP $FF1D
	BNE sync
	;
	DEC count	; beat counter
	BPL no_inc
	;
	LDA #$10	; 16 frames
	STA count
	;
	INY		; note counter
	;
	TYA
	AND #$03
	STA snare_cnt
	;
	TYA
	LSR a
	LSR a
	LSR a
	LSR a
	AND #$03
	STA channel_cnt
	;
	TYA
	AND #$0C
	LSR a           
	STA hi_pos+1
	LSR a     
	;
	TAX
	LDA frq,x	; bass: frequency low byte
	STA $FF0F
	AND #$01	; bass: use lowest bit to express high byte
	STA $FF10
	;
no_inc	LDX hi_count	; high (arpeggio note) count goes from $00-$02
	INX
	CPX #$03
	BNE no_inc2
	;
	LDX #$00
no_inc2	STX hi_count
	;
hi_pos	LDA hi_frq,x	; chords: set low byte only
	STA $FF0E	; (all freqs are in $03xx range)
	;
	LDX count
	LDA voltab,x 
	LDX channel_cnt
	AND channel_and,x
	LDX snare_cnt
	AND snare_and,x
	JSR $B8B0
	;
	BPL main	; always jump
	;
voltab     
	DB $73,$74,$75,$76,$77,$78
	DB $73,$74,$74,$75,$75,$76,$76,$77,$77,$78
	
frq          
	; base line goes: E, B, D, A
	DB 345   & 255	; odd 
	DB 118   & 255	; even 
	DB 262+1 & 255	; add 1 to make it odd
	DB   7+1 & 255	; add 1 to make it even
	;                 
channel_and
	DB $2F,$3F,$6F		; last byte is from next table
snare_and
	DB $7F,$7F,$5F,$7F
	