
string RENDERPASS = "solid";

texture Tex0 < string name = "diffuse.jpg"; int mipmaps=7; int quality=1;>;
texture Tex1 < string name = "environment.jpg"; int mipmaps=7; int quality=1;>;

float4x3 WorldView  : WORLDVIEW; 
float4x4 Projection : PROJECTION;

float4 Ambience = float4(0,0,0,0);

float TheTime : TIME;

struct VS_OUTPUT
{
    float4 Position : POSITION;
    float4 Diffuse  : COLOR0;
    float2 TexCoord : TEXCOORD0;
    float2 TexCoord2 : TEXCOORD1;
};

VS_OUTPUT VS
    (
    float4 Position : POSITION, 
    float4 Colour   : COLOR0,
    float3 Normal   : NORMAL,
    float2 TexCoord : TEXCOORD0
    )
{
    VS_OUTPUT Out = (VS_OUTPUT)0;

	float3 P = mul(Position, WorldView);                    // position (view space)
	float3 N = normalize(mul(Normal, WorldView));                    // position (view space)

	Out.Diffuse = float4(1,1,1,1);

	Out.TexCoord  = TexCoord ;

	Out.TexCoord2  = N * 0.5 + 0.5;

	Out.Position = mul(float4(P, 1), Projection);   // projected position

	   
	return Out;    
}




sampler DiffuseMap = sampler_state
{
Texture   = <Tex0>;
MinFilter = LINEAR;
MagFilter = LINEAR;
MipFilter = LINEAR;
};

sampler DiffuseMap2 = sampler_state
{
Texture   = <Tex1>;
MinFilter = LINEAR;
MagFilter = LINEAR;
MipFilter = LINEAR;
};

technique TSpecularBumpmap
{
    pass P0
    {   
        VertexShader = compile vs_1_1 VS();

       PixelShader  = NULL;

        Sampler[0] = (DiffuseMap);
        Sampler[1] = (DiffuseMap2);

	TexCoordIndex[0] =0;
	TexCoordIndex[1] =1;

	ColorArg1[0] = Texture;
	ColorArg2[0] = Diffuse;
	ColorOp[0] = Modulate;

	ColorArg1[1] = Texture;
	ColorArg2[1] = Current;
	ColorOp[1] = Modulate2X;

	ColorOp[2] = Disable;


	AlphaBlendEnable = false;
	SrcBlend = One;
	DestBlend = One;

	AlphaOp[0] = SelectArg1;
	AlphaArg1[0] = Diffuse;
	ZEnable = true;
	ZWriteEnable = true;

	CullMode = None;

	

        
    }

}