//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: MapFile.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef MapFile_hpp
#define MapFile_hpp
//==============================================================================
// Includes
#include "cVector2f.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================

const int FaceFlags_BlocksMovement = 0x01;
const int FaceFlags_BlocksShooting = 0x02;
	
//! Map file header
struct tMapFile_Header
{
	char id[5];				//!< Should be ssMAP
	char version;			//!< Map file version
	int width;				//!< Map width
	int height;				//!< Map height
	int numVertices;		//!< Number of vertices
	int numTriangles;		//!< Number of triangles
	int numQuads;			//!< Number of quads
	int numTextures;		//!< Number of textures
} __attribute__((packed));

struct tMapFile_Vertex
{
	float position[2];		//!< Position of the vertex (x,y)
	float texCoord[2];		//!< Texture coordinates of the vertex (u,v)
	float color[4];			//!< Color of the vertex (r,g,b,a)
} __attribute__((packed));

struct tMapFile_Triangle
{
	unsigned char layer;
	int texture;
	int flags;
	int vertexIndices[3];
} __attribute__((packed));

struct tMapFile_Quad
{
	unsigned char layer;
	int texture;
	int flags;
	int vertexIndices[4];
} __attribute__((packed));

//==============================================================================
}		// End of the ShootingStar namespace
#endif // MapFile_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
