//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: Main.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include <iostream>
#include <stdexcept>
#include <cstdlib>
#include <string.h>
#include "cGameCore.hpp"
#include "cObject.hpp"
#include "Debug.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
using namespace ShootingStar;
//==============================================================================

//==============================================================================
//! The main function
//------------------------------------------------------------------------------
int main (int argc, char *argv[])
{
	// Main try/catch block
	try
	{
		for ( int i = 1; i < argc; i++ )
		{
			if ( strcmp (argv[i], "--help") == 0 || 
				 strcmp (argv[i], "-h") == 0 )
			{
				cout << "Usage: game [OPTIONS]\n";
				cout << endl;
				return EXIT_SUCCESS;
			}
		}
		
		// Setup dbg
		dbg::enable (dbg::all, true);
		dbg::attach_ostream (dbg::info, cout);
		dbg::attach_ostream (dbg::warning, cout);
		dbg::enable_level_prefix (true);
		dbg::set_assertion_behaviour (dbg::all, dbg::assertions_throw);
		
		// Launch the game
		cGameCore game;
		game.Initialize (argc, argv);
		game.Run ();
		
		cObject::CleanUp ();
		
		// Normal exit
		return EXIT_SUCCESS;
	}
	catch ( runtime_error &x )	// Catch runtime errors
	{
		cerr << "Runtime error: " << x.what () << endl;
	}
	catch ( exception &x )	// Catch standard exceptions
	{
		cerr << "Exception caught: " << x.what () << endl;
	}
	catch ( ... )	// Catch all exceptions
	{
		cerr << "Unknown exception caught!" << endl;
	}
	
	cObject::CleanUp ();
	
	return EXIT_FAILURE;
};
//==============================================================================

//==============================================================================
// EOF
//==============================================================================
