//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cFlameSystem.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cFlameSystem_hpp
#define cFlameSystem_hpp
//==============================================================================
// Includes
#include "cParticleSystem.hpp"
#include "cCollidable.hpp"
#include "cOwnable.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//! Particle system used by the flame thrower
class cFlameSystem : public cParticleSystem, public cCollidable, public cOwnable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cFlameSystem (void);
		//! Destructor
		virtual ~cFlameSystem (void);
	
	// Public methods
	public:
		virtual void Update (Uint32 deltaTime) 
		{ 
			cParticleSystem::Update (deltaTime);
			mDeltaTime = deltaTime; 
		};
	
		//! Called when object collides with other object
		virtual void OnObjectCollision (cCollidable *pOther);	
		
	// Member variables
	private:
		Uint32 mDeltaTime;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cFlameSystem_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
