

play_music:

music_loop:    
    ld a,(hl)
    or a
    ret z
    
    cp $ff
    jr z,exec_code
    
    ld (play_time),a
    
    inc hl
    ld a,(hl)
    
    push hl
    ld hl,tones-2
    call add_hl_2a
    call _ldhlind
    call PlayWAV
    pop hl
    
    inc hl
    ld a,(hl)
    ld (play_time),a
    push hl
    ld hl,silent
    call PlayWAV
    pop hl
    inc hl
    jp music_loop
    
    
exec_code:
    inc hl
    push hl
    ld de,exec_code_ret
    push de
    call _ldhlind
    jp (hl)
exec_code_ret:
    pop hl
    inc hl
    inc hl
    jp music_loop
   
scroll_out:
    call clear_buffer
    
start_scroll:
    xor a
    ld hl,scroll_morph
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),a
    
    ld hl,scroll_morph_2
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),a
    
    exx
    ld de,$faff
    ld hl,$ffff
    ld bc,$80ff
    exx
    
    ret
    



stop_scroll:

    ld a,$21
    ld (scroll_morph),a
    ld hl,$ffff
    ld (scroll_morph+1),hl
    
    ld a,$c3
    ld (scroll_morph_2),a
    ld hl,skip_morph
    ld (scroll_morph_2+1),hl

    ret
    
    
        

PlayWAV:
    ld (sound_addr),hl      ;save pointer to sound
    call reset_int_counter

    call clear_port
    
    ld b,%10000000          ;b is used as a mask
    jp restart_play         ;start playing



SoundLoop:
    exx
    
    push ix
    pop af    
    
scroll_morph:
    nop
    nop
    nop
    
    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl

    rl (hl)
    dec hl
    
    ex de,hl
    
    push af
    pop ix
    
    dec b
    jp nz,scroll_done

scroll_morph_2:
    nop
    nop
    nop

    ld hl,scroll_morph
    ld a,(hl)
    xor $21
    ld (hl),a
    
    inc hl
    ld a,(hl)
    xor $ff
    ld (hl),a
    
    inc hl
    ld a,(hl)
    xor $ff
    ld (hl),a
    
skip_morph:
    ld de,$faff
    ld hl,$ffff
    ld b,128
    
    push ix
    pop af
    or a
    push af
    pop ix  
    
    
    dec c
    jp nz,scroll_done

    
    call stop_scroll

scroll_done:
    exx


continue:



    rrc b                   ;rotate mask
    jp nc,Play_delay        ;if carry was set, then go to next byte
    
    inc hl                  ;next byte
    dec d                   ;decrease loop counter
    jp nz,Play              ;if counter reaches 0, restart playing

    ld a,(int_counter)      ;get current counter value
play_time = $ + 1
    cp 0                    ;copmare to the end value for this tone
    jp nc,clear_port        ;end if it's time to end...

restart_play:
sound_addr = $+1
    ld hl,0                 ;read address
    
    ld d,30                 ;restart byte counter
    jp continue
    

Play_delay:
;waste 10 cycles
    inc e
    dec de

Play:
    ld a,(hl)               ;read current byte
    and b                   ;find 
    jp z,Play1              ;reset port if bit wasn't set
    
;else set port
    inc e
    dec de                  ;waste some time

    ld a,$fc                ;mask to set the port
    out (7),a               ;set port
    jp SoundLoop            ;next bit
    
Play1:
    ld a,$c0                ;mask to reset port
    out (7),a               ;set port
    jp SoundLoop            ;next bit
    
clear_port:
    ld  a,$c0               ;mask to reset port
    out (7),a               ;reset
    ret                     ;return
     
    


tone_1c:
 .db $F2,$13,$1B,$90,$CC,$DC,$C6,$67,$F2,$13,$0B,$98,$8C,$7C,$62,$23
 .db $F3,$11,$0F,$80,$EC,$00,$00,$00,$00,$00,$00,$00,$00,$00
 
tone_2d:
 .db $9F,$27,$11,$E4,$A2,$3C,$94,$47,$92,$88,$F0,$51,$1E,$09,$23,$C1
 .db $24,$78,$64,$0F,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00
 
tone_3e:
 .db $11,$A9,$99,$F8,$4C,$D4,$A4,$6A,$02,$7A,$53,$35,$49,$1A,$A4,$9E
 .db $90,$CD,$50,$47,$88,$00,$00,$00,$00,$00,$00,$00,$00,$00
 
tone_4f:
 .db $31,$A6,$63,$CC,$E7,$58,$CE,$98,$CC,$31,$9C,$63,$9A,$C7,$3D,$C6
 .db $75,$8E,$6B,$1C,$D3,$00,$00,$00,$00,$00,$00,$00,$00,$00
 
tone_5g:
 .db $38,$4C,$E9,$33,$AC,$CE,$B3,$32,$DC,$CB,$63,$09,$89,$26,$34,$98
 .db $92,$66,$19,$98,$66,$00,$00,$00,$00,$00,$00,$00,$00,$00
 
tone_6a:
 .db $8C,$C8,$EE,$C6,$64,$F7,$67,$B2,$73,$B3,$D1,$39,$D9,$98,$9E,$8C
 .db $CD,$4E,$42,$65,$A7,$00,$00,$00,$00,$00,$00,$00,$00,$00
 
tone_7h:
 .db $F1,$7A,$2F,$45,$E8,$99,$13,$A2,$74,$6E,$85,$F0,$BC,$17,$AB,$75
 .db $6E,$AD,$D4,$BA,$17,$40,$00,$00,$00,$00,$00,$00,$00,$00
 
tone_8c:
 .db $9D,$25,$4D,$49,$52,$4E,$93,$A2,$A8,$AD,$2F,$45,$F1,$7C,$5F,$17
 .db $E3,$F8,$BE,$27,$8D,$80,$00,$00,$00,$00,$00,$00,$00,$00
 
 
silent:
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;    .db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
;    .db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 
tones:
    .dw tone_1c
    .dw tone_2d
    .dw tone_3e
    .dw tone_4f
    .dw tone_5g
    .dw tone_6a
    .dw tone_7h
    .dw tone_8c
    .dw silent
.end