DW_RGB:	MACRO
	DW ( ((\3) << 10) + ((\2) << 5) + (\1) )
	ENDM

SETCOL:	MACRO
	ld	hl, rBCPS
	ld	[hl], $80+(\1)*2
	inc	l
	ld	[hl], \2 | ((\3 & 7) << 5)
	ld	[hl], (\4 << 2) | (\3 >> 3)
	ENDM

PUSHM:	MACRO
	REPT	_NARG
	push	\1
	SHIFT
	ENDR
	ENDM

POPM:	MACRO
	REPT	_NARG
	pop	\1
	SHIFT
	ENDR
	ENDM

PUSHA:	MACRO
	push	hl
	push	de
	push	bc
	push	af
	ENDM

POPA:	MACRO
	pop	af
	pop	bc
	pop	de
	pop	hl
	ENDM

SWAP_VBK:	MACRO
	ldio	a, [rVBK]
	;xor	1
	cpl
	ldio	[rVBK], a
	ENDM

djnz:	MACRO
	dec	b
	jr	nz, \1
	ENDM

neg:	MACRO
	cpl
	inc	a
	ENDM

ABS:	MACRO
	bit	7, a
	jr	nz, .skip\@
	cpl
	inc	a
.skip\@	ENDM

SWAIT:	MACRO
.loop\@	ldio	a, [rLY]
	cp	\1
	jr	nz, .loop\@
	ENDM
	
WAIT:	MACRO
	ld	a, \1
.loop\@	dec	a
	jr	nz, .loop
	ENDM

HDMA:	MACRO
	ld	a, (\1) >> 8
	ldio	[rHDMA1], a
	ld	a, (\1) & 255
	ldio	[rHDMA2], a
	ld	a, (\2) >> 8
	ldio	[rHDMA3], a
	ld	a, (\2) & 255
	ldio	[rHDMA4], a
	ld	a, (\3)>>8-1
	ENDM
	
MusicUpdate: MACRO
	ld	a, \1
	ld	[rROMB0], a
	call	Player_MusicUpdate
	ENDM

ROMBANK: MACRO
	ld	a, \1
	ld	[rROMB0], a
	ldh	[curbank], a
	ENDM

NEG_HL:	MACRO
	ld	a, l
	cpl
	inc	a
	ld	l, a
	ld	a, h
	sbc	a, 0
	cpl
	ld	h, a
	ENDM


START_MUSIC_INT: MACRO
	di
	xor	a
	ldh	[rSTAT], a
	ld	de, music_int
	call	setlcdcirq
	ld	a, 130
	ldh	[rLYC], a
	ld	a, %01000000
	ldh	[rSTAT], a
	ei
	ENDM

SAFE_VRWAIT: MACRO
	ldh	[\1], a
.wait\@	ldio	a, [rSTAT]
	and	2
	jr	nz, .wait\@
	ldh	a, [\1]
	ENDM
VRWAIT:	MACRO
.loop\@	ldio	a, [rSTAT]
	and	%00000010
	jr	nz, .loop\@
	ENDM
