	SECTION	"intro", HOME

fadetab	set	rampage1
text	set	rampage2

intro	START_MUSIC_INT

	ROMBANK	mathb	
	ld	hl, font
	ld	de, _VRAM+$20*16
	ld	bc, 1024
	call	vmemcopy

	ROMBANK	data1
	ld	hl, intro_tiles
	ld	de, _VRAM+$800
	ld	bc, 44*16
	call	vmemcopy

	ld	hl, stars
	ld	de, oambuf
	ld	b, 160
	call	memcpsh

	ld	hl, _SCRN0
	ld	bc, 1024
	xor	a
	call	vmemset

	ld	hl, _SCRN0+32*8
	ld	bc, 20<<8+2
	ld	a, 128+4
	call	makemap

	xor	a
	ld	[alpha], a

	ld	hl, introtx
	ld	de, text
	ld	bc, 32*8
	call	memcopy

	ld	b, 8
	ld	hl, intro_fgpal
	call	setobpal
	ld	b, 64
	ld	hl, intro_bgpal
	call	setbgpal

	ld	hl, bwfade
	ld	de, fadetab
	ld	bc, 256
	call	memcopy

	xor	a
	ldh	[counter], a

	ld	a, 0
	ld	[$ff00+$80], a
	ld	a, 42
	ld	[$ff00+$81], a
	ld	a, 85
	ld	[$ff00+$82], a

	ld	de, retint
	call	setlcdcirq

	xor	a
	ldio	[rSTAT], a
	ld	a, %10010011
	ldio	[rLCDC], a

.loop	call	waitvbl
	MusicUpdate musicb

	;ROMBANK	data1

	call	flogo
	call	intro_text
	call	starfield

	;call	twinkle
	;call	scroll

	ld	a, [counth]
	cp	time+4
	jr	c, .loop

	ret

intro_text
	ldh	a, [countl]
	and	3
	ret	nz
	ldh	a, [counter]
	ld	l, a
	inc	a
	ldh	[counter], a
	ld	h, text>>8
	ld	a, [hl]
	res	7, l
	set	6, l
	res	5, l
	ld	h, _SCRN0>>8+1
	ld	[hl], a
	ld	a, 1
	ldio	[rVBK], a
	ld	de, -7
	add	hl, de
	ld	[hl], 7
	inc	l
	ld	[hl], 6
	inc	l
	ld	[hl], 5
	inc	l
	ld	[hl], 4
	inc	l
	ld	[hl], 3
	inc	l
	ld	[hl], 2
	inc	l
	ld	[hl], 1
	inc	l
	ld	[hl], 0
	inc	l
	ld	[hl], 1
	inc	l
	ld	[hl], 2
	inc	l
	ld	[hl], 3
	inc	l
	ld	[hl], 4
	inc	l
	ld	[hl], 5
	inc	l
	ld	[hl], 6
	inc	l
	xor	a
	ldio	[rVBK], a
	ret

starfield
	ld	hl, oambuf
	ld	b, 40
.loop	ld	a, [hl]
	dec	a
	cp	16
	jr	nz, .ok
	ld	a, 144+16
.ok	ld	[hl+], a
	inc	l
	ldh	a, [counter]
	add	a, l
	sra	a
	sra	a
	and	3
	or	128
.skip	ld	[hl+], a
	inc	l
	djnz	.loop
	ld	a, h
	jp	oamdma

twinkle	ld	de, $ff80
	ld	b, 3
.loop	ld	a, [de]
	add	a, 2
	and	%01111110
	ld	[de], a
	inc	de
	ld	h, fadetab>>8
	ld	l, a
	ld	a, b
	add	a, a
	add	a, $80
	ld      [rBCPS], a
	ld	a, [hl+]
	ld	[rBCPD], a
	ld	a, [hl+]
	ld	[rBCPD], a
	djnz	.loop
	ret
	
scroll	ld	a, [countl]
	rra
	ret	c
	ld	hl, rSCY
	inc	[hl]
	ret

flogo	ld	a, [counth]
	cp	time+0
	ret	nz
	ld	a, [countl]
	cp	180
	ret	c
	ld	hl, _SCRN0+32*8
	ld	b, 64
	ld	a, 1
	ldio	[rVBK], a
.loop	ld	a, [hl]
	cp	7
	jr	z, .skip
	inc	a
	ld	[hl+], a
.skip	djnz	.loop
	xor	a
	ldio	[rVBK], a
	ret

	SECTION	"intro grafik etc", DATA, BANK[data1]

intro_tiles
	DB $00,$00,$10,$00,$00,$10,$54,$38
	DB $00,$10,$10,$00,$00,$00,$00,$00
	DB $00,$00,$00,$00,$10,$00,$28,$10
	DB $10,$00,$00,$00,$00,$00,$00,$00
	DB $00,$00,$10,$00,$00,$10,$54,$38
	DB $00,$10,$10,$00,$00,$00,$00,$00
	DB $10,$00,$00,$10,$38,$10,$BA,$7C
	DB $38,$10,$00,$10,$10,$00,$00,$00
	incbin	"oct-ugly.tls"

introtx	db	"                    XXXXXXXXXXXX"
	db	"                    XXXXXXXXXXXX"
	db	"      PRESENTS      XXXXXXXXXXXX"
	db	"   AT  BREAKPOINT   XXXXXXXXXXXX"
	db	"    EASTER  2003    XXXXXXXXXXXX"
	db	"   A DEMO  CALLED   XXXXXXXXXXXX"
	db	"    SPACE  WASTE    XXXXXXXXXXXX"
	db	"                    XXXXXXXXXXXX"

shade	set	0
bwfade	rept	32
	DW_RGB	shade, shade, shade
shade	set	shade+1
	endr
	rept	32
shade	set	shade+(-1)
	DW_RGB	shade, shade, shade
	endr

;logo	incbin	"octspr.tls"

stars	incbin	"stars.bin"

;space	incbin	"space.tls"

intro_fgpal
	DW_RGB	00, 00, 00
	DW_RGB	07, 07, 07
	DW_RGB	15, 15, 15
	DW_RGB	31, 31, 31

shade	set	0
intro_bgpal
	rept	8
	DW_RGB	0, 0, 0
	DW_RGB	0, 0, 0
	DW_RGB	shade, shade, shade
	DW_RGB	shade<<2, shade<<2, shade<<2
shade	set	shade+1
	endr

;intro_map
;	rept	8
;	db	128, 128
;	db	128+20, 12,0
;	db	128+20, 12,0
;	db	128+20, 12,0
;	db	128+20, 12,0
;	endr
;	db	0

;y	set	1
;x	set	8
;t	set	0
;sprtab	rept	20
;	db	y+78,x,t,0
;y	set	y^1
;x	set	x+8
;t	set	t+2
;	endr

time	set	time+4

