	SECTION "kubrad", HOME

palette	set	rampage1

kubrad	xor	a
	ldio	[rSTAT], a
	
	START_MUSIC_INT

	ROMBANK	mathb

	ld	a, 1
	ldio	[rVBK], a
	ld	hl, font
	ld	de, _VRAM+$20*16
	ld	bc, 1024
	call	vmemcopy
	xor	a
	ldio	[rVBK], a

	call	clearsprites

	ROMBANK	data1
	ld	hl, kubrad_tiles
	ld	de, _VRAM
	ld	bc, 207*16
	call	vmemcopy

	ld	a, 1
	ldh	[rVBK], a
	ld	hl, _SCRN0
	ld	bc, 1024
	xor	a
	call	vmemset

	xor	a
	ldh	[rVBK], a
	ld	a, 8
	ld	bc, 1024
	ld	hl, _SCRN0
	call	vmemset

	ld	hl, _SCRN0
	ld	de, kubrad_map
	ld	bc, 16<<8+32
	call	drawmap

	ld	hl, kubrad_oamdata
	ld	de, oambuf
	ld	b, 160
	call	memcpsh

;correct	ld	hl, _SCRN0
;.loop	ld	a, [hl]
;	add	a, $80
;	ld	[hl+], a
;	ld	a, $9c
;	cp	h
;	jr	nz, .loop

	;SETCOL	0, 0,0,5

	;ld	b, 40*4
	;ld	hl, oambuf
	;xor	a
	;call	memstsh

	xor	a
	ld	hl, ylist
	ld	b, 9
	call	memstsh

	ld	hl, kubrad_palette
	ld	de, palette
	ld	bc, 256
	call	memcopy

	ld	a, -16
	ldio	[rSCX], a

	ld	hl, kubrad_fgpal
	ld	b, 8
	call	setobpal

	ld	de, kubrad_irq
	call	setlcdcirq
	ld	a, %01000000
	ldio	[rSTAT], a

	ld	a, %10010011
	ldio	[rLCDC], a
	
kubrad_main
	waitVBL
	ld	a, oambuf>>8
	call	oamdma
	MusicUpdate musicb
	ROMBANK	mathb

	xor	a
	ldio	[rLYC], a
	
	ld	a, oambuf>>8
	call	oamdma

	call	kubrad_render

	;ld	a, 20
	;call	spmovr

	ld	a, [counth]
	cp	time+3
	jr	nz, kubrad_main

	ret	z

kubrad_render
	ld	b, 9
	ld	de, ylist
	ld	h, sintab >> 8
.loop	push	bc
	dec	b
	swap	b
	ldh	a, [countl]
	add	a, b
	ld	l, a
	ld	a, [hl]
	sra	a
	ld	c, a
	ldh	a, [countl]
	sub	b
	ld	l, a
	ld	a, [hl]
	sra	a
	add	a, c
	sra	a
	ld	c, a
	ld	a, [countl]
	add	a, c
	add	a, a
	add	a, a
	and	$f0
	ld	[de], a
	inc	de
	pop	bc
	djnz	.loop
	ret

kubrad_irq
	PUSHA
	ldio	a, [rLYC]
	add	a, $10
	ldio	[rLYC], a
	sub	$10
	ld	b, a
	swap	a
	and	15
	ld	l, a
	ld	h, ylist >> 8
	ld	a, b
	sub	[hl]
	neg
	ldio	[rSCY], a

	ROMBANK	data1

	ld	a, [hl]
	swap	a
	and	15
	add	a, a
	ld	l, a
	ld	h, palette >> 8

	ld	a, $82
	ld      [rBCPS], a
	ld	c, rBCPD & 255
	VRWAIT
	ld	a, [hl+]
	ld	[c], a
	ld	a, [hl+]
	ld	[c], a

	ROMBANK	mathb

	ld	a, l
	add	a, 14
	and	31
	ld	l, a
	ld	a, [hl+]
	ld	[c], a
	ld	a, [hl+]
	ld	[c], a

	POPA
	reti

	SECTION "kubrad data", DATA, BANK[data1]

kubrad_fgpal
	DW_RGB	0,0,7
	DW_RGB	0,0,0
	DW_RGB	7,7,7
	DW_RGB	31,31,31

kubrad_oamdata
y	set	140
x	set	20
p	set	1
	rept	10
	db	y,x,STRSUB("GFX EXOCET",p,1),8
x	set	x+8
p	set	p+1
	endr
	DS	(40-10)*4
	
kubrad_tiles
	incbin "kubrad.tls"
kubrad_map
	incbin "kubrad.map"

kubrad_palette
shade	SET	0
	REPT	8
	DW_RGB	31-shade, 15-shade,0
shade	SET shade+2
	ENDR
	REPT	8
shade	SET shade+(-2)
	DW_RGB	31-shade, 15-shade,0
	ENDR
	
time	set	time+3
