	SECTION "plasma", HOME

plasma	START_MUSIC_INT

	ROMBANK	data1

	ld	a, 1
	ldio	[rVBK], a
	ld	hl, _SCRN0
	ld	bc, 1024
	xor	a
	call	vmemset
	xor	a
	ldio	[rVBK], a

	ld	hl, plasma_tiles
	ld	de, _VRAM+64*16
	ld	bc, 64*16
	call	vmemcopy
	ld	de, _VRAM
	ld	bc, 40*16
	call	vmemcopy

	ld	hl, _SCRN0
	ld	b, 16
	ld	c, 4
	ld	a, $40
	call	makemap
	ld	hl, _SCRN0
	ld	de, _SCRN0+32*4
	ld	bc, 32*4*7
	call	vmemcopy
	
	call	waitvbl
	ld	hl, _SCRN0
	ld	c, 32
	call	mirrormap

	ld	hl, plasma_oamdata
	ld	de, oambuf
	ld	bc, 40*4
	call	memcopy

	; set palettes
	ld	b, 8
	ld	hl, plasma_bgpal
	call	setbgpal
	ld	b, 16
	ld	hl, plasma_obpal
	call	setobpal

	ld	a, oambuf >> 8
	call	oamdma

	ld	a, %10010111
	ldio	[rLCDC], a

	ld	de, plasma_irq
	call	setlcdcirq
	ld	a, %01000000
	ldio	[rSTAT], a
		
plasma_main
	waitVBL
	MusicUpdate musicb
	
	ld	hl, count2
	inc	[hl]
	inc	[hl]
	ld	hl, count3
	inc	[hl]
	inc	[hl]
	inc	[hl]
	
	xor	a
	ldio	[rLYC], a

	ROMBANK	mathb

	ldh	a, [countl]
	ld	h, sintab >> 8
	ld	l, a
	ld	a, [hl]
	ldio	[rSCX], a
			
	call	plasma_bord
	ld	a, oambuf >> 8
	call	oamdma
	call	plasma_render
	
	ldh	a, [counth]
	cp	time+3
	jr	nz, plasma_main
	ld	a, [countl]
	cp	192
	jr	nz, plasma_main

	xor	a
	ldio	[rSCX], a
	ldio	[rSCY], a
	
	ret

plasma_irq
	push	af
	push	hl
	ldio	a, [rLYC]
	inc	a
	ldio	[rLYC], a
	dec	a
	ld	l, a
	ld	h, ylist >> 8
	sub	[hl]
	cpl
	sra	a
	ldio	[rSCY], a
	pop	hl
	pop	af
	reti

plasma_render
	ld	b, 144
	ld	de, ylist
	ld	h, sintab >> 8
.loop	ldh	a, [count3]
	add	a, b
	ld	l, a
	ld	c, [hl]
	ldh	a, [countl]
	add	a, b
	add	a, a
	ld	l, a
	ld	a, [hl]
	sub	c
	ld	[de], a
	inc	e
	djnz	.loop
	ret

plasma_bord
	ldh	a, [count2]
	add	a, a
	and	127
	ld	h, sintab>>8
	ld	l, a
	ld	a, [hl]
	sra	a
	sra	a
	sub	16
	ld	d, a
	ld	hl, oambuf+8*4
	ld	b, 10
.loop	dec	[hl]
	jr	nz, .skip
	ld	[hl], 144+16
.skip	ld	a, d	; x
	ld	c, [hl]	; y
	REPT	3
	ld	[hl], c
	inc	l
	add	a, 8
	ld	[hl+], a
	inc	l
	inc	l
	ENDR
	dec	b
	jr	nz, .loop
	ret

	SECTION "plasma data", DATA, BANK[data1]

plasma_tiles
	INCBIN	"plasma.tls"
	INCBIN	"bord.tls"
	INCBIN	"logo1.tls"

plasma_bgpal
	DW_RGB	$00, $00, $07
	DW_RGB	$00, $07, $10
	DW_RGB	$07, $10, $17
	DW_RGB	$10, $17, $1f

plasma_obpal
	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $00
	DW_RGB	$17, $10, $00
	DW_RGB	$1f, $17, $00
	
	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $00
	DW_RGB	$0f, $0f, $0f
	DW_RGB	$1f, $1f, $1f

plasma_oamdata
tile	set	24
x	set	9
	REPT	8
	DB	148-((tile&%10)>>1)
	DB	x
	DB	tile
	DB	1
x	set	x+8
tile	set	tile+2
	ENDR
y	set	16
tile	set	0
	REPT	10
x	set	8
	REPT	3
	DB	y
	DB	x
	DB	tile
	DB	0
x	set	x+8
tile	set	(tile+2)%24
	ENDR
y	set	y+16
	ENDR
	
time	set	time+3