	SECTION "galax-virvel", HOME

angbuf	equ	$ca00
xpbuf	equ	$ca08
ypbuf	equ	$ca10

snurra	START_MUSIC_INT
	call	clearsprites
	call	flush

	ROMBANK	data1

	ld	hl, _SCRN0
	ld	bc, 20<<8+18
	xor	a
	call	makemap
	ld	hl, snurra_tiles
	ld	de, _VRAM
	ld	bc, 256*16
	call	vmemcopy
	ld	a, 1
	ldio	[rVBK], a
	ld	de, _VRAM
	ld	bc, (361-256)*16
	call	vmemcopy
	ld	de, snurra_amap
	ld	hl, _SCRN0
	call	draw20x18
	xor	a
	ldio	[rVBK], a

	ld	b, 8
	ld	hl, snurra_bgpal
	call	setbgpal
	ld	b, 8
	ld	hl, snurra_obpal
	call	setobpal

	xor	a
	ld	[rSCY], a
	ld	[rSCX], a
	ld	[rSTAT], a

	ld	de, retint
	call	setlcdcirq
	xor	a
	ldio	[rSTAT], a

	ld	a, %10010011
	ldio	[rLCDC], a

numarms	EQU	5
armlen	EQU	8

snurra_main
	rst	$10
	MusicUpdate musicb

	ROMBANK	mathb

	ld	a, oambuf >> 8
	call	oamdma

	ldh	a, [count3]
	add	a, 3
	ldh	[count3], a

	ldh	a, [count5]
	add	a, 5
	ldh	[count5], a

	ld	hl, oambuf

	xor	a
	ldh	[alpha], a

	ld	b, armlen
.loop1	
	xor	a
	ldh	[beta], a
	push	hl
	ld	h, angbuf>>8
	ld	l, b
	dec	l
	ld	a, [hl]
	ldh	[alpha], a
	ld	a, l
	add	a, 8
	ld	l, a
	ld	h, xpbuf>>8
	ld	a, [hl]
	ldh	[gamma], a
	ld	a, l
	add	a, 8
	ld	l, a
	ld	h, ypbuf>>8
	ld	a, [hl]
	ldh	[delta], a
	pop	hl

	ld	c, numarms
.loop2	push	bc

	sla	b
	sla	b
	sla	b
	dec	b

	ldh	a, [beta]
	ld	e, a
	ldh	a, [alpha]
	add	a, e
	ld	e, a

	ld	d, sintab>>8
	ld	a, [de]
	sra	a

	push	de

	push	hl
	ld	d, b
	call	fastmul	;hl=a*d
	ld	b, d
	add	hl, hl
	add	hl, hl
	add	hl, hl
	ld	d, h
	pop	hl
	ldh	a, [delta]
	add	a, d
	ld	[hl+], a
	pop	de
	
	ld	a, e
	add	a, 64
	ld	e, a
	ld	a, [de]
	sra	a

	push	hl
	ld	d, b
	call	fastmul	;hl=a*d
	add	hl, hl
	add	hl, hl
	add	hl, hl
	ld	d, h
	pop	hl
	ldh	a, [gamma]
	add	a, d
	ld	[hl+], a

	ld	[hl], $68
	inc	l
	ld	[hl], 8
	inc	l

	ldh	a, [beta]
	add	a, 256/numarms
	ldh	[beta], a
	
	pop	bc
	dec	c
	jr	nz, .loop2

	dec	b
	jr	nz, .loop1

	ld	a, [angbuf]
	push	af

	ld	de, angbuf+24
	ld	hl, angbuf+23
	ld	b, 24
.shift	ld	a, [hl-]
	ld	[de], a
	dec	de
	dec	b
	jr	nz, .shift

	ld	d, sintab>>8
	ldh	a, [countl]
	ld	e, a
	ld	a, [de]
	sra	a
	sra	a
	sra	a
	ld	b, a
	pop	af
	add	a, b
	ld	[angbuf], a

	ld	d, sintab>>8
	ldh	a, [count3]
	add	a, 64
	ld	e, a
	ld	a, [de]
	sra	a
	add	a, 80
	ld	[xpbuf], a

	call	memcpsh
	ld	d, sintab>>8
	ldh	a, [count5]
	ld	e, a
	ld	a, [de]
	sra	a
	add	a, 80
	ld	[ypbuf], a

	ld	a, [counth]
	cp	time+2
	jp	nz, snurra_main
	ld	a, [countl]
	cp	192
	jp	nz, snurra_main

	ret

	SECTION	"snurra data (?!)", DATA, BANK[1]

snurra_tiles
	INCBIN	"snurra.tls"
	DB $3C,$00,$5A,$3C,$BD,$7E,$FF,$7E
	DB $FF,$7E,$BD,$7E,$5A,$3C,$3C,$00
snurra_amap
	INCBIN	"snurra.atr"

snurra_bgpal
	DW_RGB	$00, $00, $03
	DW_RGB	$00, $06, $0a
	DW_RGB	$00, $01, $04
	DW_RGB	$00, $01, $08

snurra_obpal
	DW_RGB	$00, $00, $0f
	DW_RGB	$00, $00, $00
	DW_RGB	$0f, $0f, $0f
	DW_RGB	$1f, $1f, $1f
	
time	set	time+2