//
// Fur effect using shells and fins
//
// Note: This effect file does not work with EffectEdit.
//
#define C_ZERO              0 
#define C_ONE               1 
#define C_HALF              2 
#define C_MATTOTAL          4 
#define C_MATWORLD          8 
#define C_LIGHT_DIRECTION   20
#define C_LIGHT_AMBIENT     21
#define C_LIGHT_DIFFUSE     22
#define C_LIGHT_SPECULAR    23
#define C_MATERIAL_SPECULAR 26
#define C_EYE_POSITION      27
#define C_DISPLACEMENTS     30
#define C_TICKS             31


#define C_SIN_CONST0       70
#define C_SIN_CONST1       71
#define C_SIN_CONST2       72
#define C_SIN_CONST3       73
#define C_SIN_CONST4       74



//DEF c0,
float4 SIN_CONST0 = float4(0.0f, 0.5f, 1.0f, 0.0f    );

//DEF c1, 0.25f, -9.0f, 0.75f, 1.0f/(2.0f*PI)
float4 SIN_CONST1 = float4( 0.25f, -9.0f, 0.75f, 1.0f/(2.0f*3.1415926535) );

//DEF c2, 24.9808039603f, -24.9808039603f, -60.1458091736f, 60.1458091736
float4 SIN_CONST2 = float4( 0.25f, -9.0f, 0.75f, 1.0f/(2.0f*3.1415926535 ) );

// DEF c3, 85.4537887573f, -85.4537887573f, -64.9393539429f, 64.9393539429
float4 SIN_CONST3 = float4( 85.4537887573f, -85.4537887573f, -64.9393539429f, 64.9393539429  );

//  DEF c4, 19.7392082214f, -19.7392082214f, - 1.0f, 1.0f
float4 SIN_CONST4 = float4( 19.7392082214f, -19.7392082214f, - 1.0f, 1.0f   );



// light direction
float3 L = normalize(float3(-0.2182f, -0.8729f, 0.4364f));


float TweenFact;

// light intensity
float4 I_a = float4(0.3f, 0.3f, 0.3f, 1.0f);    // ambient
float4 I_d = float4(0.6f, 0.6f, 0.6f, 1.0f);    // diffuse
float4 I_s = float4(0.8f, 0.8f, 0.8f, 1.0f);    // reflective

// material specular 
float4 k_s = float4(1.0f, 1.0f, 1.0f, 1.0f);

// transformations
float4x4 World      : WORLD;
float4x4 View       : VIEW;
float4x4 Projection : PROJECTION;

// eye position
float3 Eye;

float4 Ticks=float4(1.0f, 1.0f, 1.0f, 1.0f);

// textures
texture FinTex;
texture ShellTex;

// shell properties
float ShellThickness = 0.4f;
float ShellScalingFactor;

static const float4 vOne = float4(1, 1, 1, 1);

// vertex shaders
VertexShader ShellVS = asm
{
	;------------------------------------------------------------------------------
	; Constants specified by the app
	;    c0      = ( 0, 0, 0, 0 )
	;    c1      = ( 1, 1, 1, 1 )
	;    c4-c7   = matWorldViewProjection
	;    c8-c10  = matWorld
	;    c20     = light direction (in model space)
	;    c21     = light ambient
	;    c22     = light diffuse
	;    c23     = light specular
	;    c26     = material specular
	;    c27     = eye position (world space)
	;    c30.x   = normal displacement total
	;    c30.y   = normal displacement as a 0 to 1 pct of total
	;    c30.z   = self-shadowing factor
	;
	; Vertex components (as specified in the vertex DECL)
	;    v0    = Position
	;    v3    = Normal
	;    v4    = diffuse
	;    v6    = Texcoords
	;------------------------------------------------------------------------------
	vs.1.1

	dcl_position v0
	dcl_normal   v3
	dcl_color0   v4
	dcl_texcoord v6

        mov r1,c31.x
        mov r0,r1
        mov r2,r1

       add r1.x,r1.x,c30.y


          add r1,r1,v6
          mul r1,r1,c31.z
          // Sinus Function
          // Src = r1.x
          // Dest = r0.x
          // temp = r2
     /////////////////////
     /////////////////////
     /////////////////////


 mad    r1.x, c71.w, r1.x,  -c71.x


 expp    r1.y, r1.x
 slt    r2.x, r1.y, c71
 sge      r2.yz, r1.y, c71
 dp3      r2.y, r2, c74.zwzw
  add    r0.xyz, -r1.y, c70
 mul    r0, r0, r0
   mad       r1, c72.xyxy, r0, c72.zwzw
    mad    r1, r1, r0, c73.xyxy
    mad    r1, r1, r0, c73.zwzw
    mad    r1, r1, r0, c74.xyxy
     mad   r1, r1, r0, c74.zwzw
     dp3   r0.x, r1, -r2
     /////////////////////
     /////////////////////
     /////////////// Sinus





	// OUTPUT POSITION
	// in model space, add some normal to the position
	mul r5.z, c30.x, c30.y
	mul r5, r5.z, v3

     //   mul r5,r5,r0.x

	add r5, r5, v0
	mov r5.w, v0.w


 	//add r5.xyz,r5.xyz,r0.x
	// transform vertex position by total matrix and output it
	dp4 oPos.x, r5, c4
	dp4 oPos.y, r5, c5
	dp4 oPos.z, r5, c6
	dp4 oPos.w, r5, c7

         mov r1,v6 
         add r1.x,r1.x,r0.x
	// output the texture coordinates
	mov oT0, r1
};

 
technique Shells
{
    pass P0
    {
        // render states
        AlphaTestEnable  = TRUE;

        // texture
        Texture[0] = (ShellTex);

        // vertex shader
        VertexShader = (ShellVS);
        PIXELShader = Null;

        VertexShaderConstantF[C_DISPLACEMENTS] = float4(0.5f * ShellThickness, ShellScalingFactor, 0.5f * (1 + ShellScalingFactor), 0.0f) ;
        VertexShaderConstantF[C_EYE_POSITION]  = (Eye);
        VertexShaderConstantF[C_MATTOTAL]      = (mul(mul(World, View), Projection));
        VertexShaderConstantF[C_MATWORLD]      = (World);
               VertexShaderConstantF[C_TICKS]      = (Ticks);

      
        VertexShaderConstantF[C_SIN_CONST0]      = (SIN_CONST0);
        VertexShaderConstantF[C_SIN_CONST1]      = (SIN_CONST1);
        VertexShaderConstantF[C_SIN_CONST2]      = (SIN_CONST2);
        VertexShaderConstantF[C_SIN_CONST3]      = (SIN_CONST3);
        VertexShaderConstantF[C_SIN_CONST4]      = (SIN_CONST4);


    }
}

