
//
// Note: This effect file does not work with EffectEdit.
//
#define C_COMMONCONST              0
#define C_PIVECTOR                 1
#define C_SIN7                     2
#define C_COS8                     3
#define C_MAT_VIEWPROJ             4
#define C_EYE                      8
#define C_LIGHTPOS                 9
#define C_FRCFIXUP                 10
#define C_WAVEHEIGHTS              11
#define C_WAVEOFFSET               12
#define C_WAVESPEED                13
#define C_WAVEDIRX                 14
#define C_WAVEDIRY                 15
#define C_TIME                     16
#define C_SINTIME                  17
#define C_BUMPSPEED                18
#define C_TEXCOORD_DISTORSION      19
#define C_MAT_INVERSE_VIEW         20


float4 COMMONCONST=float4(0,0.5,1,2);
float4 PIVECTOR=float4(4.0f,1.57080,3.14159,6.28319);
float4 SIN7=float4(1,-0.16667,0.00833,-0.00020);
float4 COS8=float4(0.5,-0.04167,0.00139,-0.00002);
float4 LIGHTPOS=float4(1.0f, 11.0f, 1.0f, 1.0f);
float4 FRCFIXUP=float4(0.98,0.003,0,0);
float4 WAVEHEIGHTS=float4(1.0f, 1.0f, 1.0f, 1.0f);
float4 WAVEOFFSET=float4(0,0.2,0,0);
float4 WAVESPEED=float4(1.0f, 1.0f, 1.0f, 1.0f);
float4 WAVEDIRX=float4(1.0f, 1.0f, 1.0f, 1.0f);
float4 WAVEDIRY=float4(1.0f, 1.0f, 1.0f, 1.0f);
float4 TIME=float4(1.0f, 1.0f, 1.0f, 1.0f);
float4 SINTIME=float4(1.0f, 1.0f, 1.0f, 1.0f);
float4 BUMPSPEED=float4(1.0f, 1.0f, 1.0f, 1.0f);
float4 TEXCOORD_DISTORSION=float4(11.0f, 11.0f, 1.0f, 1.0f);


// transformations
float4x4 World      : WORLD;
float4x4 View       : VIEW;
float4x4 MAT_INVERSE_VIEW    ;
float4x4 Projection : PROJECTION;

// eye position
float3 Eye;

float4 Specular=float4(1.0f, 1.0f, 1.0f, 1.0f);
float4 Ticks=float4(1.0f, 1.0f, 1.0f, 1.0f);
float3 Ticks2=float3(1.0f, 1.0f, 1.0f);

static const float4 vOne = float4(1, 1, 1, 1);

// Textures 
// Defined by effect ...

texture tex_BumpMap;

texture tex_Water;

texture tex_EnvMap;


// vertex shaders
VertexShader Water_VS = asm
{vs.1.1

dcl_position   v0
dcl_normal     v1  
dcl_color0   v4
dcl_texcoord   v2
//dcl_tangent    v3
//dcl_binormal   v4

//============================================//
// use tex coords as input to sinusoidal warp //
//============================================//
mul  r0, c14, v2.x
mad  r0, c15, v2.y, r0
mul r0,r0,c19

mov  r1, c16.x        // time...
mad  r0, r1, c13, r0  // add scaled time to move bumps according to freq
add  r0, r0, c12      // starting time offset
frc  r0.xy, r0        // take frac of all 4 components
frc  r1.xy, r0.zwzw   //
mov  r0.zw, r1.xyxy   //

mul  r0, r0, c10.x    // mul by fixup (due to inaccuracy)
sub  r0, r0, c0.y     // subtract 0.5
mul  r0, r0, c1.w     // mul tex coords by 2pi  (coords range from -pi to pi)

mul  r5, r0, r0       // (wave vec)^2
mul  r1, r5, r0       // (wave vec)^3
mul  r6, r1, r0       // (wave vec)^4
mul  r2, r6, r0       // (wave vec)^5
mul  r7, r2, r0       // (wave vec)^6
mul  r3, r7, r0       // (wave vec)^7
mul  r8, r3, r0       // (wave vec)^8

mad  r4, r1, c2.y, r0 // (wave vec) ((wave vec)^3)/3!
mad  r4, r2, c2.z, r4 // + ((wave vec)^5)/5!
mad  r4, r3, c2.w, r4 // ((wave vec)^7/7!

mov  r0, c0.z         // 1
mad  r5, r5, c3.x, r0 // -(wave vec)^2/2!
mad  r5, r6, c3.y, r5 // +(wave vec)^4/4!
mad  r5, r7, c3.z, r5 // -(wave vec)^6/6!
mad  r5, r8, c3.w, r5 // +(wave vec)^8/8!

sub  r0, c0.z, c0.x   //... 1-wave scale
mul  r4, r4, r0       // scale sin
mul  r5, r5, r0       // scale cos

dp4  r0, r4, c11      // mul by wave heights

mul r0.xyz, v1, r0    // mul wave mag at this vertex by normal
add r0.xyz, r0, v0    // add to position
mov r0.w, c0.z        // homogenous component

m4x4 oPos, r0, c4     // Outpos = ObjSpace * World-view-proj matrix

mul  r1, r5, c11      // cos * wave height
dp4  r9.x, -r1, c14   // normal x offset
dp4  r9.yzw, -r1, c15 // normal y offset and tangent offset
mov  r5, v1           // starting normal
mad  r5.xy, r9, c10.y, r5  //warped normal move nx, ny according to
                           // cos*wavedir*waveheight
mov  r4, v1           // tangent
mad  r4.z, -r9.x, c10.y, r4.z  // warped tangent vector

dp3 r10.x, r5, r5     // normalize the normal
rsq  r10.y, r10.x
mul  r5, r5, r10.y

dp3 r10.x, r4, r4     // normalize the tangent
rsq  r10.y, r10.x
mul  r4, r4, r10.y

mul  r3, r4.yzxw, r5.zxyw   // xprod to find binormal
mad  r3, r4.zxyw, -r5.yzxw, r3


mov  r2, c8           // get eye pos into object space
//m4x4 r2, r6, c20

sub  r2, r2, r0       // find view vector

dp3  r10.x, r2, r2    // normalize view vector
rsq  r10.y, r10.x
mul  r2, r2, r10.y

mov  r0, c16.x
mul  r0, r0, c18.xyxy
frc  r0.xy, r0        // frac of incoming time
add  r0, v2, r0       // add time to tex coords
mov  oT0, r0          // output tex coords

mov  r0, c16.x
mul  r0, r0, c18.zwzw
frc  r0.xy, r0        // frac of incoming time
add  r0, v2, r0       // add time to tex coords
mov  oT1, r0.yxzw     // output distorted tex coord1

mov  oT2, r2          // pass in view vector (world space)
mov  oT3, r3          // tangent 
mov  oT4, r4          // binormal
mov  oT5, r5          // normal
 







  





  




  

};

      
// Pixel shaders
PixelShader Water_PS = asm
{
   
ps.1.4

def c0, 0.5, 0.5, 0.5, 1.0

def c1, 0.5, 0.5, 0.5, 1.0

texld  r0, t0     // bump map 0
texld  r1, t1     // bump map 1
texcrd r2.rgb, t2 // view vec
texcrd r3.rgb, t3 // tangent
texcrd r4.rgb, t4 // binormal
texcrd r5.rgb, t5 // normal

add_d4 r0.xy, r0_bx2, r1_bx2 // scaled avg of 2 bumpmap xy offsets

mul  r1.rgb, r0.x, r3        // put bump maps into world space
mad  r1.rgb, r0.y, r4, r1  
mad  r1.rgb, r0.z, r5, r1

dp3  r0.rgb, r1, r2          // V.N
mad  r2.rgb, r1, r0_x2, -r2  // R = 2N(V.N)-V

mov_sat  r0.rgb, r0_x2           // 2 * V.N (sample over range of 1D map)

phase

texld  r2, r2             // env map
texld  r3, r0             // index frenel map using 2*N.V

mul  r2.rgb, r2, r2          // square env map
+mul r2.a, r2.g, r2.g        // use green of env as specular
mul  r2.rgb, r2, 1-r0.r      // fresnel term
+mul r2.a, r2.a, r2.a        // specular ^4

add_d4_sat r2.rgb, r2, r3_x2  // += water color
+mul  r2.a, r2.a, r2.a        // specular ^8

mad_sat r0, r2.a, c1, r2      // += specular * specular color 



















} ;

// techniques
technique Init
{
    pass P0
    {
        // render states
       // CullMode = NONE;

    //    AmbientMaterialSource = COLOR1;
    //    DiffuseMaterialSource = COLOR1;

    //    BlendOp   = ADD;
    //    SrcBlend  = SRCALPHA;
    //    DestBlend = INVSRCALPHA;

   //     AlphaTestEnable = FALSE;
   //     AlphaFunc       = GREATER;
   //     AlphaRef        = 0;

  //      AlphaBlendEnable = TRUE;

        // texture stage states
 //       AlphaOp[0]   = MODULATE;
  //      AlphaArg1[0] = TEXTURE;
  //      AlphaArg2[0] = CURRENT;


 //       Lighting = FALSE;


        // transforms
        ViewTransform       = (View);
        ProjectionTransform = (Projection);
    }
}
sampler ClampedLinear = 
sampler_state
{
    AddressU  = WRAP;
    AddressV  = WRAP;
    AddressW  = WRAP;
    MipFilter = NONE;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

technique Water
{
    pass P0
    {
        // render states
        AlphaTestEnable  = TRUE;

        // texture

        // vertex shader
        VertexShader = (Water_VS);
        PixelShader = (Water_PS);


         
        Sampler[0]  = (ClampedLinear);

        Sampler[1]  = (ClampedLinear);

        Sampler[2]  = (ClampedLinear);

        Sampler[3]  = (ClampedLinear);
                 
           
    
        AlphaOp[0]   = SELECTARG1;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = CURRENT;
        

        ColorOp[0]   = MODULATE;
        ColorArg1[0] = CURRENT;
        ColorArg2[0] = TEXTURE;
        
         AlphaOp[1]   = SELECTARG1;
        AlphaArg1[1] = TEXTURE;
        AlphaArg2[1] = CURRENT;
        
    
        ColorOp[1]   = MODULATE;
        ColorArg1[1] = CURRENT;
        ColorArg2[1] = TEXTURE;
        
            AlphaOp[2]   = SELECTARG1;
        AlphaArg1[2] = TEXTURE;
        AlphaArg2[2] = CURRENT;
        

        ColorOp[2]   = MODULATE;
        ColorArg1[2] = CURRENT;
        ColorArg2[2] = TEXTURE;

            AlphaOp[3]   = SELECTARG1;
        AlphaArg1[3] = TEXTURE;
        AlphaArg2[3] = CURRENT;
        
    
        ColorOp[3]   = MODULATE;
        ColorArg1[3] = CURRENT;
        ColorArg2[3] = TEXTURE;
        ColorArg0[3] = TEXTURE;

        Lighting = FALSE;

      Texture[0] = (tex_BumpMap);
      Texture[1] = (tex_BumpMap);
      Texture[2] = (tex_Water);
        Texture[3] = (tex_EnvMap);


        VertexShaderConstantF[C_MAT_VIEWPROJ]      = ( mul(mul(World, View), Projection));
        VertexShaderConstantF[C_COMMONCONST]      = (COMMONCONST);
        VertexShaderConstantF[C_PIVECTOR]      = (PIVECTOR);
        VertexShaderConstantF[C_SIN7]      = (SIN7);
        VertexShaderConstantF[C_COS8]      = (COS8);
        VertexShaderConstantF[C_EYE]      = (Eye);
        VertexShaderConstantF[C_LIGHTPOS]      = (LIGHTPOS);
        VertexShaderConstantF[C_FRCFIXUP]      = (FRCFIXUP);
        VertexShaderConstantF[C_WAVEHEIGHTS]      = (WAVEHEIGHTS);
        VertexShaderConstantF[C_WAVEOFFSET]      = (WAVEOFFSET);
        VertexShaderConstantF[C_WAVESPEED]      = (WAVESPEED);
        VertexShaderConstantF[C_WAVEDIRX]      = (WAVEDIRX);
        VertexShaderConstantF[C_WAVEDIRY]      = (WAVEDIRY);
        VertexShaderConstantF[C_TIME]      = (Ticks );
        VertexShaderConstantF[C_SINTIME]      = sin(Ticks.x);
        VertexShaderConstantF[C_BUMPSPEED]      = (BUMPSPEED);
        VertexShaderConstantF[C_TEXCOORD_DISTORSION]      = ( TEXCOORD_DISTORSION);
        VertexShaderConstantF[C_MAT_INVERSE_VIEW]      = ( MAT_INVERSE_VIEW);


    }
}
