
// Copyright (c) Jacobo Tarro Barreiro.
// All rights reserved.

// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither Jacobo Tarro Barreiro's name nor the names of his contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.

// THIS SOFTWARE IS PROVIDED BY JACOBO TARRO BARREIRO AND THE CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JACOBO TARRO BARREIRO OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef __CONSTS_HPP
#define __CONSTS_HPP

namespace rtb {

  class Consts {
  public:
    enum rotate_type {
      ROTATE_ROBOT=1,
      ROTATE_CANNON=2,
      ROTATE_ROBOT_CANNON=3,
      ROTATE_RADAR=4,
      ROTATE_ROBOT_RADAR=5,
      ROTATE_CANNON_RADAR=6,
      ROTATE_ALL=7
    };

    enum warning_type {
      UNKNOWN_MESSAGE=0,
      PROCESS_TIME_LOW=1,
      MESSAGE_SENT_IN_ILLEGAL_STATE=2,
      UNKNOWN_OPTION=3,
      OBSOLETE_KEYWORD=4
    };

    enum game_option_type {
      ROBOT_MAX_ROTATE=0,
      ROBOT_CANNON_MAX_ROTATE=1,
      ROBOT_RADAR_MAX_ROTATE=2,
      ROBOT_MAX_ACCELERATION=3,
      ROBOT_MIN_ACCELERATION=4,
      ROBOT_START_ENERGY=5,
      ROBOT_MAX_ENERGY=6,
      ROBOT_ENERGY_LEVELS=7,
      SHOT_SPEED=8,
      SHOT_MIN_ENERGY=9,
      SHOT_MAX_ENERGY=10,
      SHOT_ENERGY_INCREASE_SPEED=11,
      TIMEOUT=12,
      DEBUG_LEVEL=13,		// 0 - no debug, 5 - highest debug level
      SEND_ROBOT_COORDINATES=14	// 0 - no coords, 1 - relative to initial position, 2 - absolute
    };

    enum robot_option_type {
      SEND_SIGNAL=0,		// 0 - false, 1 - true
      SEND_ROTATION_REACHED=1,	// 0 - no messages, 1 - messages when RotateTo and RotateAmount finished, 2 - messages also when sweep direction is changed 
      SIGNAL=2,			// 0 - no signal, > 1 signal to send
      USE_NON_BLOCKING=3	// 0 - false, 1 - true
    };

    enum object_type {
      IS_NOOBJECT=-1, 
      IS_ROBOT=0, 
      IS_SHOT=1, 
      IS_WALL=2, 
      IS_COOKIE=3, 
      IS_MINE=4,
      IS_LAST_OBJECT_TYPE=5
    };
  };
}

#endif
