
// Copyright (c) Jacobo Tarro Barreiro.
// All rights reserved.

// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither Jacobo Tarro Barreiro's name nor the names of his contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.

// THIS SOFTWARE IS PROVIDED BY JACOBO TARRO BARREIRO AND THE CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JACOBO TARRO BARREIRO OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#include "consts.hpp"
#include <string>

#ifndef __ROBOT_HPP
#define __ROBOT_HPP

namespace rtb {

  class Robot {
  private:
    std::string _name;
    int _colour;
    int _away_colour;

    /*
     * Functions called by the scanner as commands from the arena server
     */
  protected:
    virtual void Initialize(int first) { if (_name != "") { Name (_name); Colour (_colour, _away_colour); } }
    virtual void YourName(std::string name) { };
    virtual void YourColour(int colour) { };
    virtual void GameOption(Consts::game_option_type option, double value) { };
    virtual void GameStarts() { };
    virtual void Radar(double distance, Consts::object_type object, double radar_angle) { };
    virtual void Info(double time, double speed, double cannon_angle) { };
    virtual void Coordinates(double x, double y, double z) { };
    virtual void RobotInfo(double energy, int teammate) { };
    virtual void RotationReached(Consts::rotate_type what) { };
    virtual void Energy(double energy) { };  
    virtual void RobotsLeft(int number) { };
    virtual void Collision(Consts::object_type object, double angle) { };
    virtual void Warning(Consts::warning_type type, std::string message) { };
    virtual void Dead() { };
    virtual void GameFinishes() { };
    virtual void ExitRobot() { exit (0); };

    /*
     * Functions called by the user as commands for the arena server
     */

    void RobotOption(Consts::robot_option_type option, int value);
    void Name(std::string name);
    void Colour (int colour, int away_colour);
    void Rotate (Consts::rotate_type what, double angular);
    void RotateTo (Consts::rotate_type what, double angular, double end);
    void RotateAmount (Consts::rotate_type what, double angular, double angle);
    void Sweep (Consts::rotate_type what, double angular, double left, double right);
    void Accelerate(double value);
    void Brake(double portion);
    void Shoot(double energy);
    void Print(std::string message);
    void Debug(std::string message);
    void DebugLine(double angle1, double radius1, double angle2, double radius2);
    void DebugCircle(double center_angle, double center_radius, double circle_radius);

    /*
     * You wouldn't normally modify this
     */

    void OptimizedParser (void);

    /*
     * This is the function that runs the robot
     */

  public:
    Robot (std::string name, int colour, int away_colour);
    virtual ~Robot() { }
    void Scanner (void);
  };
}

#endif
