import java.applet.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import javax.media.*;

/**
 * JMFApplet provide a simple JMF media player that can be used
 * to play audio or video streams in your JMF-enabled browser of choice.
 * <p>
 * IMPORTANT:  This source code example is offered under the license at:
 * http://wireless.java.sun.com/berkeley_license.html
 * 
 * @author Bill Day <bill.day@sun.com>
 * @version 1.1
 * @see javax.media.ControllerEvent
 * @see javax.media.ControllerListener
 * @see javax.media.Manager
 * @see javax.media.NoPlayerException
 * @see javax.media.Player
 * @see javax.media.RealizeCompleteEvent
**/

public class Example05 extends Applet implements ControllerListener { 
    private URL myURL = null;
    private Player myPlayer = null;
    private Component myVisual = null;
    private Component myControls = null;
    private Panel visualPanel = null;

    /**
     * Initialize JMFApplet.  We lay out the interface and
     * create our player in the init().
    **/
    public void init() {
        super.init();
        
        // Specify AWT Layout Manager.
        setLayout (new BorderLayout());

        // Load URL from the web page JMFApplet is embedded in.
        String asset = getParameter("ASSET");

        // Check the URL and create a URL object to hold it.
        if (asset.equals("")) {
           //we haven't entered an asset in the applet.
        } else {
           try {
              myURL = new URL(getDocumentBase(),asset);
           } catch (MalformedURLException e) {
              //We entered an incomplete asset or built incorrect URL.
              //More robust applet should handle this gracefully.
           }   
        }
        try {
           //Here's an interesting bit.  Manager is used to 
           //create the actual player for this URL.  We then
           //add JMFApplet as a ControllerListener for myPlayer.
           //This lets us respond to RealizeCompleteEvents.
           myPlayer = Manager.createPlayer(myURL);
           myPlayer.addControllerListener(this);
        } catch (IOException e) {
           // Encountered some problem with I/O; exit.
           System.out.println("I/O problem attempting to create player...exiting");
           System.exit(1);
        } catch (NoPlayerException e) {
           // Unable to return a usable Player; exit.
           System.out.println("No usable Player returned...exiting");
           System.exit(1);
        }
    }

    /**
     * Override the default applet start method to call Player's
     * realize().  This will first do the realization, which in turn
     * triggers the final bits of GUI building in the controllerUpdate()
     * method.  We do not automatically start playback:  The user needs
     * to click on the "play" button in our applet to start playing the
     * media sample.
    **/
    public void start() {
       myPlayer.realize();
    }

     
    /**
     * Override the default applet stop method to call myPlayer.stop()
     * and myPlayer.deallocate() so that we properly free up resources
     * if someone exits this page in their browser.
    **/
    public void stop() {
       myPlayer.stop();
       myPlayer.deallocate();
    }

    /**
     * Since we must know when realize completes, we use 
     * controllerUpdate() to handle RealizeCompleteEvents.
     * When we receive the RealizeCompleteEvent, we layout 
     * and display the video component and controls in our 
     * applet GUI.
    **/
    public void controllerUpdate(ControllerEvent event) {
       if (event instanceof RealizeCompleteEvent) {
          //System.out.println("Received RCE...");
          // Now that we have a Realized player, we can get the
          // VisualComponent and ControlPanelComponent and pack
          // them into our applet.
          myVisual = myPlayer.getVisualComponent();
          if (myVisual != null) {
             // In order to ensure that the VisualComponent
             // is not resized by BorderLayout, I nest it
             // within visualPanel using FlowLayout.
             visualPanel = new Panel();
             visualPanel.setLayout(new FlowLayout()); 
             visualPanel.add(myVisual);
             add(visualPanel,BorderLayout.CENTER);
             //System.out.println("Added VisualComponent...");
           }
           myControls = myPlayer.getControlPanelComponent();
           if (myControls != null) {
              add(myControls,BorderLayout.SOUTH);
              //System.out.println("Added controls...");
           }
           //invalidate();
           validate();
       }
       // Else we simply consume the event.
    }
}
